/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.subtile;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.IManaPool;

/**
 * The basic class for a Functional Flower.
 */
public class TileEntityFunctionalFlower extends TileEntitySpecialFlower {
	private static final class_2960 POOL_ID = new class_2960(BotaniaAPI.MODID, "mana_pool");
	public static final int LINK_RANGE = 10;

	private static final String TAG_MANA = "mana";

	private static final String TAG_POOL_X = "poolX";
	private static final String TAG_POOL_Y = "poolY";
	private static final String TAG_POOL_Z = "poolZ";

	private int mana;

	public int redstoneSignal = 0;

	int sizeLastCheck = -1;
	class_2586 linkedPool = null;

	class_2338 cachedPoolCoordinates = null;

	public TileEntityFunctionalFlower(class_2591<?> type) {
		super(type);
	}

	/**
	 * If set to true, redstoneSignal will be updated every tick.
	 */
	public boolean acceptsRedstone() {
		return false;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		linkPool();

		if (linkedPool != null && isValidBinding()) {
			IManaPool pool = (IManaPool) linkedPool;
			int manaInPool = pool.getCurrentMana();
			int manaMissing = getMaxMana() - mana;
			int manaToRemove = Math.min(manaMissing, manaInPool);
			pool.receiveMana(-manaToRemove);
			addMana(manaToRemove);
		}

		if (acceptsRedstone()) {
			redstoneSignal = 0;
			for (class_2350 dir : class_2350.values()) {
				int redstoneSide = method_10997().method_8499(method_11016().method_10093(dir), dir);
				redstoneSignal = Math.max(redstoneSignal, redstoneSide);
			}
		}

		if (method_10997().field_9236) {
			double particleChance = 1F - (double) mana / (double) getMaxMana() / 3.5F;
			int color = getColor();
			float red = (color >> 16 & 0xFF) / 255F;
			float green = (color >> 8 & 0xFF) / 255F;
			float blue = (color & 0xFF) / 255F;
			if (Math.random() > particleChance) {
				BotaniaAPI.instance().sparkleFX(method_10997(), method_11016().method_10263() + 0.3 + Math.random() * 0.5, method_11016().method_10264() + 0.5 + Math.random() * 0.5, method_11016().method_10260() + 0.3 + Math.random() * 0.5, red, green, blue, (float) Math.random(), 5);
			}
		}
	}

	public void linkPool() {
		boolean needsNew = false;
		if (linkedPool == null) {
			needsNew = true;

			if (cachedPoolCoordinates != null) {
				needsNew = false;
				if (method_10997().method_22340(cachedPoolCoordinates)) {
					needsNew = true;
					class_2586 tileAt = method_10997().method_8321(cachedPoolCoordinates);
					if (tileAt instanceof IManaPool && !tileAt.method_11015()) {
						linkedPool = tileAt;
						needsNew = false;
					}
					cachedPoolCoordinates = null;
				}
			}
		} else {
			class_2586 tileAt = method_10997().method_8321(linkedPool.method_11016());
			if (tileAt instanceof IManaPool) {
				linkedPool = tileAt;
			}
		}

		if (needsNew && ticksExisted == 1) { // Only for new flowers
			IManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
			int size = network.getAllPoolsInWorld(method_10997()).size();
			if (BotaniaAPI.instance().shouldForceCheck() || size != sizeLastCheck) {
				linkedPool = network.getClosestPool(method_11016(), method_10997(), LINK_RANGE);
				sizeLastCheck = size;
			}
		}

		method_5431();
	}

	public void linkToForcefully(class_2586 pool) {
		linkedPool = pool;
		method_5431();
	}

	public int getMana() {
		return mana;
	}

	public void addMana(int mana) {
		this.mana = class_3532.method_15340(this.mana + mana, 0, getMaxMana());
		method_5431();
	}

	@Override
	public boolean onWanded(class_1657 player, class_1799 wand) {
		if (player == null) {
			return false;
		}

		class_2378.field_11156.method_17966(DING_SOUND_EVENT).ifPresent(evt -> player.method_5783(evt, 0.1F, 1F));

		return super.onWanded(player, wand);
	}

	public int getMaxMana() {
		return 20;
	}

	public int getColor() {
		return 0xFFFFFF;
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		mana = cmp.method_10550(TAG_MANA);

		int x = cmp.method_10550(TAG_POOL_X);
		int y = cmp.method_10550(TAG_POOL_Y);
		int z = cmp.method_10550(TAG_POOL_Z);

		cachedPoolCoordinates = y < 0 ? null : new class_2338(x, y, z);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_MANA, mana);

		if (cachedPoolCoordinates != null) {
			cmp.method_10569(TAG_POOL_X, cachedPoolCoordinates.method_10263());
			cmp.method_10569(TAG_POOL_Y, cachedPoolCoordinates.method_10264());
			cmp.method_10569(TAG_POOL_Z, cachedPoolCoordinates.method_10260());
		} else {
			int x = linkedPool == null ? 0 : linkedPool.method_11016().method_10263();
			int y = linkedPool == null ? -1 : linkedPool.method_11016().method_10264();
			int z = linkedPool == null ? 0 : linkedPool.method_11016().method_10260();

			cmp.method_10569(TAG_POOL_X, x);
			cmp.method_10569(TAG_POOL_Y, y);
			cmp.method_10569(TAG_POOL_Z, z);
		}
	}

	@Override
	public class_2338 getBinding() {
		if (linkedPool == null) {
			return null;
		}
		return linkedPool.method_11016();
	}

	@Override
	public boolean canSelect(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		return true;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		int range = 10;
		range *= range;

		double dist = pos.method_10262(method_11016());
		if (range >= dist) {
			class_2586 tile = player.field_6002.method_8321(pos);
			if (tile instanceof IManaPool) {
				linkedPool = tile;
				return true;
			}
		}

		return false;
	}

	public boolean isValidBinding() {
		return linkedPool != null
				&& linkedPool.method_11002()
				&& !linkedPool.method_11015()
				&& method_10997().method_22340(linkedPool.method_11016())
				&& method_10997().method_8321(linkedPool.method_11016()) == linkedPool;
	}

	public class_1799 getHudIcon() {
		return class_2378.field_11142.method_17966(POOL_ID).map(class_1799::new).orElse(class_1799.field_8037);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void renderHUD(class_4587 ms, class_310 mc) {
		String name = class_1074.method_4662(method_11010().method_26204().method_9539());
		int color = getColor();
		BotaniaAPIClient.instance().drawComplexManaHUD(ms, color, getMana(), getMaxMana(), name, getHudIcon(), isValidBinding());
	}

}
