/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.subtile;

import net.minecraft.class_2338;
import net.minecraft.class_238;

/**
 * This object describes the Radius of a SubTileEntity. It can either be
 * a circle or rectangle, it's to note that the
 */
public class RadiusDescriptor {

	private final class_2338 subtileCoords;

	public RadiusDescriptor(class_2338 subtileCoords) {
		this.subtileCoords = subtileCoords;
	}

	public class_2338 getSubtileCoords() {
		return subtileCoords;
	}

	public boolean isCircle() {
		return false;
	}

	public double getCircleRadius() {
		return 0;
	}

	public class_238 getAABB() {
		return null;
	}

	public static class Circle extends RadiusDescriptor {

		final double radius;

		public Circle(class_2338 subtileCoords, double radius) {
			super(subtileCoords);
			this.radius = radius;
		}

		@Override
		public boolean isCircle() {
			return true;
		}

		@Override
		public double getCircleRadius() {
			return radius;
		}

	}

	public static class Rectangle extends RadiusDescriptor {

		final class_238 aabb;

		public Rectangle(class_2338 subtileCoords, class_238 aabb) {
			super(subtileCoords);
			this.aabb = aabb;
		}

		@Override
		public class_238 getAABB() {
			return aabb;
		}

	}

	public static class Square extends Rectangle {

		public Square(class_2338 subtileCoords, int expand) {
			super(subtileCoords, new class_238(subtileCoords.method_10069(-expand, 0, -expand), subtileCoords.method_10069(expand + 1, 0, expand + 1)));
		}

	}

}
