/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.state;

import com.google.common.base.Predicates;
import net.minecraft.class_2350;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;

/**
 * Holds all Botania block state properties. Use these to set botania blockstates
 */
public final class BotaniaStateProps {

	// The property for floating flower island type
	// todo 1.16-fabric public static final ModelProperty<IFloatingFlower> FLOATING_DATA = new ModelProperty<>();

	// BlockAlfPortal
	public static final class_2754<AlfPortalState> ALFPORTAL_STATE = class_2754.method_11850("state", AlfPortalState.class);

	// BlockEnchanter
	public static final class_2754<class_2350.class_2351> ENCHANTER_DIRECTION = class_2754.method_11848("facing", class_2350.class_2351.class, Predicates.not(Predicates.equalTo(class_2350.class_2351.field_11052)));

	// BlockCraftyCrate
	public static final class_2754<CratePattern> CRATE_PATTERN = class_2754.method_11850("pattern", CratePattern.class);

	// BlockPrism
	public static final class_2746 HAS_LENS = class_2746.method_11825("has_lens");

	private BotaniaStateProps() {}

}
