/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana.spark;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public final class SparkHelper {

	public static final int SPARK_SCAN_RANGE = 12;

	public static Stream<ISparkEntity> getSparksAround(class_1937 world, double x, double y, double z, class_1767 color) {
		return getSparksAround(world, x, y, z).stream().filter(s -> s.getNetwork() == color);
	}

	public static List<ISparkEntity> getSparksAround(class_1937 world, double x, double y, double z) {
		return SparkHelper.getEntitiesAround(ISparkEntity.class, world, x, y, z);
	}

	public static <T> List<T> getEntitiesAround(Class<? extends T> clazz, class_1937 world, double x, double y, double z) {
		int r = SPARK_SCAN_RANGE;
		@SuppressWarnings("unchecked")
		List<T> entities = (List<T>) (List<?>) world.method_8390(class_1297.class, new class_238(x - r, y - r, z - r, x + r, y + r, z + r), Predicates.instanceOf(clazz));
		return entities;
	}

}
