/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2586;

public interface ManaNetworkCallback {
	Event<ManaNetworkCallback> EVENT = EventFactory.createArrayBacked(ManaNetworkCallback.class,
			listeners -> (be, typ, act) -> {
				for (ManaNetworkCallback listener : listeners) {
					listener.onNetworkChange(be, typ, act);
				}
			});

	void onNetworkChange(class_2586 be, ManaBlockType type, Action action);

	public static void addCollector(class_2586 tile) {
		EVENT.invoker().onNetworkChange(tile, ManaBlockType.COLLECTOR, Action.ADD);
	}

	public static void removeCollector(class_2586 tile) {
		EVENT.invoker().onNetworkChange(tile, ManaBlockType.COLLECTOR, Action.REMOVE);
	}

	public static void addPool(class_2586 tile) {
		EVENT.invoker().onNetworkChange(tile, ManaBlockType.POOL, Action.ADD);
	}

	public static void removePool(class_2586 tile) {
		EVENT.invoker().onNetworkChange(tile, ManaBlockType.POOL, Action.REMOVE);
	}

	public enum ManaBlockType {
		POOL, COLLECTOR
	}

	public enum Action {
		REMOVE, ADD
	}
}
