/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.minecraft.class_1799;
import net.minecraft.class_2586;

/**
 * An item that implements this can be counted as an item that can
 * contain mana.
 */
public interface IManaItem {

	/**
	 * Gets the amount of mana this item contains
	 */
	public int getMana(class_1799 stack);

	/**
	 * Gets the max amount of mana this item can hold.
	 */
	public int getMaxMana(class_1799 stack);

	/**
	 * Adds mana to this item.
	 */
	public void addMana(class_1799 stack, int mana);

	/**
	 * Can this item receive mana from a mana Pool?
	 * 
	 * @param pool The pool it's receiving mana from, can be casted to IManaPool.
	 * @see IManaPool#isOutputtingPower()
	 */
	public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool);

	/**
	 * Can this item recieve mana from another item?
	 */
	public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack);

	/**
	 * Can this item export mana to a mana Pool?
	 * 
	 * @param pool The pool it's exporting mana to, can be casted to IManaPool.
	 * @see IManaPool#isOutputtingPower()
	 */
	public boolean canExportManaToPool(class_1799 stack, class_2586 pool);

	/**
	 * Can this item export mana to another item?
	 */
	public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack);

	/**
	 * If this item simply does not export mana at all, set this to true. This is
	 * used to skip items that contain mana but can't export it when drawing the
	 * mana bar above the XP bar.
	 */
	public boolean isNoExport(class_1799 stack);

}
