/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana;

import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import vazkii.botania.api.internal.IManaBurst;

/**
 * Have an item implement this for it to count as a lens effect and
 * be able to change the properties of Mana Bursts.
 */
public interface ILensEffect {

	/**
	 * Called when a mana spreader that has this focus shoots a burst. This is where
	 * you change the properties of the burst.
	 */
	public void apply(class_1799 stack, BurstProperties props);

	/**
	 * Called when a mana burst fired from a mana spreader with this focus collides against
	 * any block. This is called after the collision is handled.
	 * 
	 * @return True to kill the burst. False to keep it alive.
	 */
	public boolean collideBurst(IManaBurst burst, class_239 pos, boolean isManaBlock, boolean dead, class_1799 stack);

	/**
	 * Called when a mana burst fired from a mana spreader with this focus is updated.
	 * This is called before the update is handled.
	 */
	public void updateBurst(IManaBurst burst, class_1799 stack);

	/**
	 * Called when the mana burst should do it's particles. Return false to not
	 * do any particles.
	 */
	public boolean doParticles(IManaBurst burst, class_1799 stack);

	/**
	 * Gets the amount of mana to transfer to the passed in mana receiver block.
	 */
	public default int getManaToTransfer(IManaBurst burst, class_1799 stack, IManaReceiver receiver) {
		return burst.getMana();
	}

	/**
	 * @deprecated use the version without the entity argument and call burst.entity() instead
	 */
	@Deprecated
	public default int getManaToTransfer(IManaBurst burst, class_1682 entity, class_1799 stack, IManaReceiver receiver) {
		return getManaToTransfer(burst, stack, receiver);
	}

}
