/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import java.util.UUID;

/**
 * An item that implements this counts as a Relic item. This is purely for interaction
 * and other mod items should not implement this interface.
 */
public interface IRelic {

	/**
	 * Binds to the UUID passed in.
	 */
	public void bindToUUID(UUID uuid, class_1799 stack);

	/**
	 * Gets the UUID of the person this relic is bound to, or null if a well-formed UUID could not be found
	 */
	@Nullable
	public UUID getSoulbindUUID(class_1799 stack);

	/**
	 * Checks if the relic contains a well-formed UUID.
	 */
	public boolean hasUUID(class_1799 stack);

	/**
	 * Get the advancement granted when this relic binds
	 */
	@Nullable
	default class_2960 getAdvancement() {
		return null;
	}

}
