/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import javax.annotation.Nonnull;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import java.util.Locale;

/**
 * Base Interface for the Petal Apothecary block. Can
 * be safely casted to TileEntity.
 */
public interface IPetalApothecary {
	enum State implements class_3542 {
		EMPTY,
		WATER,
		LAVA;

		@Nonnull
		@Override
		public String method_15434() {
			return name().toLowerCase(Locale.ROOT);
		}

		public class_3611 asVanilla() {
			switch (this) {
			default:
			case EMPTY:
				return class_3612.field_15906;
			case WATER:
				return class_3612.field_15910;
			case LAVA:
				return class_3612.field_15908;
			}
		}
	}

	/**
	 * Set the contained fluid.
	 */
	public void setFluid(State fluid);

	/**
	 * Get the contained fluid.
	 */
	public State getFluid();
}
