/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import vazkii.botania.api.mana.ManaProficiencyCallback;

/**
 * An armor item that implements this gives the player wearing it mana proficiency, by
 * which it makes Rods the player use have a stronger effect. This is a boolean, and only
 * one armor piece with this returning true is required for the player to be considered
 * to be having proficiency, by which it's suggested that this is used alongside an
 * armor set, where only one piece implements it.
 */
public interface IManaProficiencyArmor {

	default boolean shouldGiveProficiency(class_1799 armorStack, class_1304 slot, class_1657 player, class_1799 rod) {
		return false;
	}

	static boolean hasProficiency(class_1657 player, class_1799 rod) {
		boolean proficient = false;

		for (class_1304 e : class_1304.values()) {
			if (e.method_5925() != class_1304.class_1305.field_6178) {
				continue;
			}
			class_1799 armor = player.method_6118(e);
			if (!armor.method_7960()) {
				class_1792 item = armor.method_7909();
				if (item instanceof IManaProficiencyArmor && ((IManaProficiencyArmor) item).shouldGiveProficiency(armor, e, player, rod)) {
					proficient = true;
					break;
				}
			}
		}

		return ManaProficiencyCallback.EVENT.invoker().getProficient(player, rod, proficient);
	}

}
