/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

/**
 * A Block that implements this can be uprooted by the various horns in Botania.
 */
public interface IHornHarvestable {

	/**
	 * Returns true if this block can be uprooted.
	 * Note that the stack param can be empty if it's a drum breaking it.
	 */
	public boolean canHornHarvest(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType);

	/**
	 * Returns true if harvestByHorn() should be called. If false it just uses the normal
	 * block breaking method.
	 * Note that the stack param can be empty if it's a drum breaking it.
	 */
	public boolean hasSpecialHornHarvest(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType);

	/**
	 * Called to harvest by a horn.
	 * Note that the stack param can be empty if it's a drum breaking it.
	 */
	public void harvestByHorn(class_1937 world, class_2338 pos, class_1799 stack, EnumHornType hornType);

	public static enum EnumHornType {

		/**
		 * Horn of the Wild, for grass and crops
		 */
		WILD,

		/**
		 * Horn of the Canopy, for leaves
		 */
		CANOPY,

		/**
		 * Horn of the Covering, for snow
		 */
		COVERING
	};

}
