/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.internal;

import javax.annotation.Nullable;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import java.util.UUID;

/**
 * Interface for the Mana Burst entity. This can safely be casted to EntityThrowable.
 */
public interface IManaBurst {

	boolean isFake();

	void setBurstMotion(double x, double y, double z);

	int getColor();

	void setColor(int color);

	int getMana();

	void setMana(int mana);

	int getStartingMana();

	void setStartingMana(int mana);

	int getMinManaLoss();

	void setMinManaLoss(int minManaLoss);

	float getManaLossPerTick();

	void setManaLossPerTick(float mana);

	float getBurstGravity();

	void setGravity(float gravity);

	class_2338 getBurstSourceBlockPos();

	void setBurstSourceCoords(class_2338 pos);

	class_1799 getSourceLens();

	void setSourceLens(class_1799 lens);

	boolean hasAlreadyCollidedAt(class_2338 pos);

	void setCollidedAt(class_2338 pos);

	int getTicksExisted();

	void setFake(boolean fake);

	void setShooterUUID(UUID uuid);

	UUID getShooterUUID();

	void ping();

	/**
	 * @return True if a warp lens has already warped this burst once
	 */
	boolean hasWarped();

	void setWarped(boolean warped);

	int getOrbitTime();

	void setOrbitTime(int time);

	/**
	 * @return Whether an entity has tripped this burst for the tripwire lens
	 */
	boolean hasTripped();

	void setTripped(boolean tripped);

	/**
	 * @return The position this burst is magnetized towards
	 */
	@Nullable
	class_2338 getMagnetizedPos();

	void setMagnetizePos(@Nullable class_2338 pos);

	/**
	 * @return this Mana Burst as an ThrowableEntity
	 */
	default class_1682 entity() {
		return (class_1682) this;
	}
}
