/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.corporea;

import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

/**
 * An interface for a Corporea Request matcher. Accepts an ItemStack and returns whether it fulfills the request.
 */
public interface ICorporeaRequestMatcher extends Predicate<class_1799> {

	/**
	 * Returns whether the given stack matches the request's criteria.
	 */
	@Override
	default boolean test(class_1799 stack) {
		return false;
	}

	/**
	 * Serialize to NBT data, for the Corporea Retainer's benefit.
	 */
	default void writeToNBT(class_2487 tag) {}

	/**
	 * Returns the pretty name of the requested item, for printing request feedback on Corporea Indexes.
	 */
	default class_2561 getRequestName() {
		return new class_2585("missingno");
	}

	enum Dummy implements ICorporeaRequestMatcher {
		INSTANCE
	}
}
