/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;

import vazkii.botania.api.item.IFloatingFlower;

import java.util.Collections;
import java.util.Map;

/**
 * Class for API calls that must be made clientside
 */
@Environment(EnvType.CLIENT)
public interface BotaniaAPIClient {
	class_3528<BotaniaAPIClient> INSTANCE = new class_3528<>(() -> {
		try {
			return (BotaniaAPIClient) Class.forName("vazkii.botania.client.impl.BotaniaAPIClientImpl").newInstance();
		} catch (ReflectiveOperationException e) {
			LogManager.getLogger().warn("Unable to find BotaniaAPIClientImpl, using a dummy");
			return new BotaniaAPIClient() {};
		}
	});

	static BotaniaAPIClient instance() {
		return INSTANCE.method_15332();
	}

	/**
	 * Registers your model for island type islandType here.
	 * Call this during {@link net.minecraftforge.client.event.ModelRegistryEvent}.
	 *
	 * @param islandType The islandtype to register
	 * @param model      The model, only {@link ResourceLocation} allowed, no {@link ModelResourceLocation} allowed.
	 */
	default void registerIslandTypeModel(IFloatingFlower.IslandType islandType, class_2960 model) {}

	/**
	 * @return An immutable and live view of the registered island type model map
	 */
	default Map<IFloatingFlower.IslandType, class_2960> getRegisteredIslandTypeModels() {
		return Collections.emptyMap();
	}

	/**
	 * Draw a mana bar on the screen
	 */
	default void drawSimpleManaHUD(class_4587 ms, int color, int mana, int maxMana, String name) {}

	/**
	 * Performs the effects of {@link #drawSimpleManaHUD}, then renders {@code bindDisplay}, and a checkmark or x-mark
	 * dependong on the value of {@code properlyBound}.
	 */
	default void drawComplexManaHUD(class_4587 ms, int color, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {}
}
