/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.AfterBatch;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.DelegatingConfigAccess;
import vazkii.botania.test.TestingUtil;
import vazkii.botania.xplat.BotaniaConfig;

public class BoreLensTest {
    private static final String ARENA = "botania:item/lens/lens_mine";
    private static final String WOOD_LEVEL_BATCH = "botania:lens_mine_test_mining_level_0";
    private static final String STONE_LEVEL_BATCH = "botania:lens_mine_test_mining_level_1";
    private static final String IRON_LEVEL_BATCH = "botania:lens_mine_test_mining_level_2";
    private static final String DIAMOND_LEVEL_BATCH = "botania:lens_mine_test_mining_level_3";

    private void mockMiningLevel(final int level) {
        BotaniaConfig.setCommon(new DelegatingConfigAccess(BotaniaConfig.common()){

            @Override
            public int harvestLevelBore() {
                return level;
            }
        });
    }

    private void restoreConfig() {
        BotaniaConfig.setCommon(((DelegatingConfigAccess)BotaniaConfig.common()).getInner());
    }

    @BeforeBatch(batch="botania:lens_mine_test_mining_level_0")
    public void beforeWoodBatch(ServerLevel level) {
        this.mockMiningLevel(0);
    }

    @BeforeBatch(batch="botania:lens_mine_test_mining_level_1")
    public void beforeStoneBatch(ServerLevel level) {
        this.mockMiningLevel(1);
    }

    @BeforeBatch(batch="botania:lens_mine_test_mining_level_2")
    public void beforeIronBatch(ServerLevel level) {
        this.mockMiningLevel(2);
    }

    @BeforeBatch(batch="botania:lens_mine_test_mining_level_3")
    public void beforeDiamondBatch(ServerLevel level) {
        this.mockMiningLevel(3);
    }

    @AfterBatch(batch="botania:lens_mine_test_mining_level_0")
    public void afterWoodBatch(ServerLevel level) {
        this.restoreConfig();
    }

    @AfterBatch(batch="botania:lens_mine_test_mining_level_1")
    public void afterStoneBatch(ServerLevel level) {
        this.restoreConfig();
    }

    @AfterBatch(batch="botania:lens_mine_test_mining_level_2")
    public void afterIronBatch(ServerLevel level) {
        this.restoreConfig();
    }

    @AfterBatch(batch="botania:lens_mine_test_mining_level_3")
    public void afterDiamondBatch(ServerLevel level) {
        this.restoreConfig();
    }

    private void testMine(GameTestHelper helper, Block toMine, boolean expectSuccess) {
        BlockPos spreaderPos = new BlockPos(1, 2, 0);
        BlockPos manaVoidPos = new BlockPos(1, 2, 3);
        BlockPos lampPos = new BlockPos(2, 2, 2);
        BlockPos buttonPos = new BlockPos(2, 2, 0);
        BlockPos testPos = new BlockPos(1, 2, 1);
        Player player = helper.m_177368_();
        ManaSpreaderBlockEntity spreader = TestingUtil.assertBlockEntity(helper, spreaderPos, BotaniaBlockEntities.SPREADER);
        TestingUtil.assertThat(spreader.bindTo(player, new ItemStack((ItemLike)BotaniaItems.twigWand), helper.m_177449_(manaVoidPos), Direction.UP), () -> "Failed to bind spreader");
        helper.m_177245_(testPos, toMine);
        if (expectSuccess) {
            helper.m_177425_().m_177546_(1, () -> helper.m_177385_(buttonPos)).m_177552_(() -> helper.m_177255_(lampPos, (Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))).m_177543_();
        } else {
            helper.m_177425_().m_177546_(1, () -> helper.m_177385_(buttonPos)).m_177559_(60, () -> helper.m_177255_(lampPos, (Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(false))).m_177543_();
        }
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_0")
    public void testSnow(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50127_, true);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_0")
    public void testStone(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50069_, true);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_0")
    public void testLog(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_49999_, true);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_0")
    public void testIronBlockTooLow(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50075_, false);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_1")
    public void testIronBlock(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50075_, true);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_1")
    public void testGoldOreTooLow(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_49995_, false);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_2")
    public void testGoldOre(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_49995_, true);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_2")
    public void testObsidianTooLow(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50080_, false);
    }

    @GameTest(template="botania:item/lens/lens_mine", batch="botania:lens_mine_test_mining_level_3")
    public void testObsidian(GameTestHelper helper) {
        this.testMine(helper, Blocks.f_50080_, true);
    }
}

