/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class BindingTest {
    private static final String TEMPLATE = "botania:block/flower_binding_arena";

    @GameTest(template="botania:block/flower_binding_arena")
    public void functionalFlowerAutoBindTest(GameTestHelper helper) {
        this.autobindTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
    }

    @GameTest(template="botania:block/flower_binding_arena")
    public void generatingFlowerAutoBindTest(GameTestHelper helper) {
        this.autobindTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
    }

    private void autobindTest(GameTestHelper helper, Block bindTargetBlock, Block flower, int maxDistance) {
        BlockPos middle = new BlockPos(16, 16, 16);
        helper.m_177245_(middle, bindTargetBlock);
        BlockPos absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).m_58899_();
        List<BlockPos> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<BlockPos> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.m_177306_(1L, () -> {
            justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
            tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
            helper.m_177412_();
        });
    }

    @GameTest(template="botania:block/flower_binding_arena")
    public void functionalFlowerManualBindTest(GameTestHelper helper) {
        this.manualBindTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
    }

    @GameTest(template="botania:block/flower_binding_arena")
    public void generatingFlowerManualBindTest(GameTestHelper helper) {
        this.manualBindTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
    }

    private void manualBindTest(GameTestHelper helper, Block bindTargetBlock, Block flower, int maxDistance) {
        BlockPos middle = new BlockPos(16, 16, 16);
        List<BlockPos> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<BlockPos> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.m_177245_(middle, bindTargetBlock);
        BlockPos absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).m_58899_();
        justCloseEnough.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));
        tooFarAway.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));
        justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
        tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
        helper.m_177412_();
    }

    @GameTest(template="botania:block/flower_binding_arena")
    public void functionalFlowerObedienceStick(GameTestHelper helper) {
        this.obedienceStickTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
    }

    @GameTest(template="botania:block/flower_binding_arena")
    public void generatingFlowerObedienceStick(GameTestHelper helper) {
        this.obedienceStickTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
    }

    private void obedienceStickTest(GameTestHelper helper, Block bindTargetBlock, Block flower, int maxDistance) {
        BlockPos middle = new BlockPos(16, 16, 16);
        List<BlockPos> justCloseEnough = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance);
        List<BlockPos> tooFarAway = BindingTest.placeAxialFlowers(helper, middle, flower, maxDistance + 1);
        helper.m_177245_(middle, bindTargetBlock);
        BlockPos absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).m_58899_();
        Player player = helper.m_177368_();
        player.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BotaniaItems.obedienceStick));
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, middle);
        justCloseEnough.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, absoluteBindTarget));
        tooFarAway.forEach(pos -> BindingTest.assertFlowerBoundTo(helper, pos, null));
        helper.m_177412_();
    }

    private static List<BlockPos> placeAxialFlowers(GameTestHelper helper, BlockPos center, Block flower, int distance) {
        return Arrays.stream(Direction.values()).map(dir -> center.m_5484_(dir, distance)).peek(pos -> helper.m_177245_(pos, flower)).collect(Collectors.toList());
    }

    private static void assertFlowerBoundTo(GameTestHelper helper, BlockPos relativePos, @Nullable BlockPos absoluteBindTarget) {
        Object message = absoluteBindTarget == null ? "Flower should not have bound" : "Flower should have bound to " + absoluteBindTarget;
        BlockEntity be = TestingUtil.assertAnyBlockEntity(helper, relativePos);
        if (be instanceof GeneratingFlowerBlockEntity) {
            GeneratingFlowerBlockEntity tege = (GeneratingFlowerBlockEntity)be;
            TestingUtil.assertEqualsAt(helper, relativePos, tege.getBinding(), absoluteBindTarget, () -> BindingTest.lambda$assertFlowerBoundTo$11((String)message));
        } else if (be instanceof FunctionalFlowerBlockEntity) {
            FunctionalFlowerBlockEntity tefe = (FunctionalFlowerBlockEntity)be;
            TestingUtil.assertEqualsAt(helper, relativePos, tefe.getBinding(), absoluteBindTarget, () -> BindingTest.lambda$assertFlowerBoundTo$12((String)message));
        } else {
            TestingUtil.throwPositionedAssertion(helper, relativePos, () -> "Expected a flower here");
        }
    }

    private static /* synthetic */ String lambda$assertFlowerBoundTo$12(String message) {
        return message;
    }

    private static /* synthetic */ String lambda$assertFlowerBoundTo$11(String message) {
        return message;
    }
}

