/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.shared;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.text.NumberFormat;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.LocaleHelper;
import vazkii.botania.common.handler.OrechidManager;

public class OrechidUIHelper {
    private static final float MAX_ACCEPTABLE_RATIO_ERROR = 0.05f;
    private static final int MAX_NUM_INPUTS_FOR_RATIO = 16;

    @NotNull
    public static Component getPercentageComponent(double chance) {
        String chanceText = LocaleHelper.formatAsPercentage(chance, 1);
        return Component.m_237113_((String)chanceText);
    }

    @NotNull
    public static Component getRatioTooltipComponent(@NotNull IntIntPair ratio) {
        NumberFormat formatter = LocaleHelper.getIntegerFormat();
        return Component.m_237110_((String)"botaniamisc.conversionRatio", (Object[])new Object[]{formatter.format(ratio.secondInt()), formatter.format(ratio.firstInt())});
    }

    @NotNull
    public static Component getBiomeChanceTooltipComponent(double chance, @NotNull String biomeTranslationKey) {
        return Component.m_237110_((String)"botaniamisc.conversionChanceBiome", (Object[])new Object[]{OrechidUIHelper.getPercentageComponent(chance), Component.m_237115_((String)biomeTranslationKey).m_130940_(ChatFormatting.ITALIC)}).m_130940_(ChatFormatting.GRAY);
    }

    @NotNull
    public static Stream<Component> getBiomeChanceAndRatioTooltipComponents(double chance, OrechidRecipe recipe) {
        String biomeTranslationKey = OrechidUIHelper.getPlayerBiomeTranslationKey();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (biomeTranslationKey == null || player == null) {
            return Stream.empty();
        }
        Double biomeChance = OrechidUIHelper.getChance(recipe, player.m_20183_());
        if (biomeChance == null || Mth.m_14082_((double)chance, (double)biomeChance)) {
            return Stream.empty();
        }
        IntIntPair biomeRatio = OrechidUIHelper.getRatioForChance(biomeChance);
        return Stream.of(OrechidUIHelper.getBiomeChanceTooltipComponent(biomeChance, biomeTranslationKey), Component.m_237113_((String)"(").m_7220_(OrechidUIHelper.getRatioTooltipComponent(biomeRatio)).m_130946_(")").m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public static <T extends OrechidRecipe> Double getChance(T recipe, @Nullable BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        RecipeType<? extends OrechidRecipe> type = recipe.m_6671_();
        BlockState state = recipe.getInput().getDisplayed().get(0);
        int totalWeight = OrechidManager.getTotalDisplayWeightAt((Level)level, type, state, pos);
        int weight = pos != null ? recipe.getWeight((Level)level, pos) : recipe.getWeight();
        return (double)weight / (double)totalWeight;
    }

    @NotNull
    public static IntIntPair getRatioForChance(double actualRatio) {
        int bestNumOutputs = 1;
        int bestNumInputs = (int)Math.round(1.0 / actualRatio);
        double bestError = OrechidUIHelper.calcError(actualRatio, bestNumOutputs, bestNumInputs);
        if (bestNumInputs < 16 && bestError > (double)0.05f) {
            int numOutputsNminus1 = 1;
            int numOutputsNminus2 = 0;
            int numInputsNminus1 = 0;
            int numInputsNminus2 = 1;
            double remainderN = actualRatio;
            do {
                int coefficientN = (int)Math.floor(remainderN);
                int numOutputsN = coefficientN * numOutputsNminus1 + numOutputsNminus2;
                int numInputsN = coefficientN * numInputsNminus1 + numInputsNminus2;
                if (numInputsN > 16) break;
                double errorN = OrechidUIHelper.calcError(actualRatio, numOutputsN, numInputsN);
                if (errorN < bestError) {
                    bestNumOutputs = numOutputsN;
                    bestNumInputs = numInputsN;
                    bestError = errorN;
                }
                numOutputsNminus2 = numOutputsNminus1;
                numOutputsNminus1 = numOutputsN;
                numInputsNminus2 = numInputsNminus1;
                numInputsNminus1 = numInputsN;
                remainderN = 1.0 / (remainderN - (double)coefficientN);
            } while (numInputsNminus1 != 0 && bestError > (double)0.05f);
        }
        return IntIntImmutablePair.of((int)bestNumInputs, (int)bestNumOutputs);
    }

    private static double calcError(double chance, int numOutputs, int numInputs) {
        return Math.abs((double)numOutputs / (double)numInputs - chance) / chance;
    }

    public static String getPlayerBiomeTranslationKey() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        ResourceKey biomeKey = player.m_9236_().m_204166_(player.m_20183_()).m_203543_().orElse(null);
        if (biomeKey == null) {
            return "argument.id.invalid";
        }
        return String.format("biome.%s.%s", biomeKey.m_135782_().m_135827_(), biomeKey.m_135782_().m_135815_());
    }
}

