/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ElvenTradeProvider
extends BotaniaRecipeProvider {
    public ElvenTradeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public void buildRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dreamwood_log"), new ItemStack((ItemLike)BotaniaBlocks.dreamwoodLog), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwoodLog})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dreamwood"), new ItemStack((ItemLike)BotaniaBlocks.dreamwood), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.livingwood})));
        Ingredient manaDiamond = Ingredient.m_204132_(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaSteel = Ingredient.m_204132_(BotaniaTags.Items.INGOTS_MANASTEEL);
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elementium"), new ItemStack((ItemLike)BotaniaItems.elementium), manaSteel, manaSteel));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elementium_block"), new ItemStack((ItemLike)BotaniaBlocks.elementiumBlock), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.manasteelBlock}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.manasteelBlock})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("pixie_dust"), new ItemStack((ItemLike)BotaniaItems.pixieDust), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dragonstone"), new ItemStack((ItemLike)BotaniaItems.dragonstone), manaDiamond));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("dragonstone_block"), new ItemStack((ItemLike)BotaniaBlocks.dragonstoneBlock), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.manaDiamondBlock})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elf_quartz"), new ItemStack((ItemLike)BotaniaItems.elfQuartz), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42692_})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("elf_glass"), new ItemStack((ItemLike)BotaniaBlocks.elfGlass), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaBlocks.manaGlass})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("iron_return"), new ItemStack((ItemLike)Items.f_42416_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("iron_block_return"), new ItemStack((ItemLike)Blocks.f_50075_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50075_})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("ender_pearl_return"), new ItemStack((ItemLike)Items.f_42584_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42584_})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("diamond_return"), new ItemStack((ItemLike)Items.f_42415_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})));
        consumer.accept(new FinishedElvenRecipe(ElvenTradeProvider.id("diamond_block_return"), new ItemStack((ItemLike)Blocks.f_50090_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50090_})));
        consumer.accept(new FinishedRecipe(){

            public void m_7917_(JsonObject obj) {
            }

            public ResourceLocation m_6445_() {
                return ElvenTradeProvider.id("lexicon_elven");
            }

            public RecipeSerializer<?> m_6637_() {
                return BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        });
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("elven_trade/" + path);
    }

    public String m_6055_() {
        return "Botania elven trade recipes";
    }

    protected static class FinishedElvenRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<Ingredient> inputs;
        private final List<ItemStack> outputs;

        public FinishedElvenRecipe(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
            this(id, Arrays.asList(inputs), Collections.singletonList(output));
        }

        protected FinishedElvenRecipe(ResourceLocation id, List<Ingredient> inputs, List<ItemStack> outputs) {
            this.id = id;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public void m_7917_(JsonObject json) {
            JsonArray in = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                in.add(ingr.m_43942_());
            }
            JsonArray out = new JsonArray();
            for (ItemStack s : this.outputs) {
                out.add((JsonElement)ItemNBTHelper.serializeStack(s));
            }
            json.add("ingredients", (JsonElement)in);
            json.add("output", (JsonElement)out);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

