/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vazkii.botania.common.item.ItemWithBannerPattern;

@Mixin(value={LoomMenu.class})
public abstract class LoomMenuMixin
extends AbstractContainerMenu {
    @Shadow
    @Final
    Slot patternSlot;

    protected LoomMenuMixin(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @Inject(at={@At(value="HEAD")}, method={"getSelectablePatterns(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"}, cancellable=true)
    private void handleBotaniaPatternItems(ItemStack stack, CallbackInfoReturnable<List<Holder<BannerPattern>>> cir) {
        Item item = stack.m_41720_();
        if (item instanceof ItemWithBannerPattern) {
            ItemWithBannerPattern p = (ItemWithBannerPattern)item;
            cir.setReturnValue((Object)((List)BuiltInRegistries.f_256878_.m_203431_(p.getBannerPattern()).map(ImmutableList::copyOf).orElse(ImmutableList.of())));
        }
    }

    @Inject(at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;")}, method={"quickMoveStack"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void handleBotaniaPatternQuickMoveStack(Player player, int slotIndex, CallbackInfoReturnable<ItemStack> cir, ItemStack dummyStack, Slot slot, ItemStack movedStack) {
        if (movedStack.m_41720_() instanceof ItemWithBannerPattern && this.m_38903_(movedStack, this.patternSlot.f_40219_, this.patternSlot.f_40219_ + 1, false)) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
        }
    }
}

