/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;

public class ManaPrismBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements ManaTrigger {
    public ManaPrismBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.PRISM, pos, state);
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        TinyPlanetExcempt excempt;
        Item item;
        boolean valid;
        ItemStack lens = this.getItemHandler().m_8020_(0);
        boolean active = (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) == false;
        boolean bl = valid = !lens.m_41619_() && lens.m_41720_() instanceof BasicLensItem && (!((item = lens.m_41720_()) instanceof TinyPlanetExcempt) || (excempt = (TinyPlanetExcempt)item).shouldPull(lens));
        if (active) {
            burst.setSourceLens(valid ? lens.m_41777_() : ItemStack.f_41583_);
            burst.setColor(0xFFFFFF);
            burst.setGravity(0.0f);
            if (valid) {
                ThrowableProjectile burstEntity = burst.entity();
                BurstProperties properties = new BurstProperties(burst.getStartingMana(), burst.getMinManaLoss(), burst.getManaLossPerTick(), burst.getBurstGravity(), 1.0f, burst.getColor());
                ((BasicLensItem)lens.m_41720_()).apply(lens, properties, this.f_58857_);
                burst.setColor(properties.color);
                burst.setStartingMana(properties.maxMana);
                burst.setMinManaLoss(properties.ticksBeforeManaLoss);
                burst.setManaLossPerTick(properties.manaLossPerTick);
                burst.setGravity(properties.gravity);
                burstEntity.m_20256_(burstEntity.m_20184_().m_82490_((double)properties.motionModifier));
            }
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean m_7013_(int index, ItemStack stack) {
                return !stack.m_41619_() && stack.m_41720_() instanceof BasicLensItem;
            }

            public int m_6893_() {
                return 1;
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean hasLens;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            BlockState state = this.m_58900_();
            boolean bl = hasLens = !this.getItemHandler().m_8020_(0).m_41619_();
            if (!state.m_60713_(BotaniaBlocks.prism) || (Boolean)state.m_61143_((Property)BotaniaStateProperties.HAS_LENS) != hasLens) {
                BlockState base = state.m_60713_(BotaniaBlocks.prism) ? state : BotaniaBlocks.prism.m_49966_();
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)base.m_61124_((Property)BotaniaStateProperties.HAS_LENS, (Comparable)Boolean.valueOf(hasLens)));
            }
        }
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPrismBlockEntity prism;

        public WandHud(ManaPrismBlockEntity prism) {
            this.prism = prism;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack lens = this.prism.m_8020_(0);
            if (!lens.m_41619_()) {
                Component lensName = lens.m_41786_();
                int halfWidth = (mc.f_91062_.m_92852_((FormattedText)lensName) + 24) / 2;
                int centerX = mc.m_91268_().m_85445_() / 2;
                int centerY = mc.m_91268_().m_85446_() / 2;
                RenderHelper.renderHUDBox(gui, centerX - halfWidth, centerY + 8, centerX + halfWidth, centerY + 28);
                gui.m_280430_(mc.f_91062_, lensName, centerX - halfWidth + 22, centerY + 14, 0xFFFFFF);
                gui.m_280203_(lens, centerX - halfWidth + 2, centerY + 10);
            }
        }
    }
}

