/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class OrechidBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int COST = 17500;
    private static final int COST_GOG = 700;
    private static final int DELAY = 100;
    private static final int DELAY_GOG = 2;
    private static final int RANGE = 5;
    private static final int RANGE_Y = 3;

    protected OrechidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public OrechidBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaFlowerBlocks.ORECHID, pos, state);
    }

    @Override
    public void tickFlower() {
        BlockPos coords;
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0 || !this.canOperate()) {
            return;
        }
        if (this.getMana() >= this.getCost() && this.ticksExisted % this.getDelay() == 0 && (coords = this.getCoordsToPut()) != null) {
            this.trySetRecipe(coords, this.findMatchingRecipe(coords));
        }
    }

    protected void playSound(BlockPos coords) {
        this.m_58904_().m_5594_(null, coords, BotaniaSounds.orechid, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Nullable
    private OrechidRecipe findMatchingRecipe(BlockPos coords) {
        BlockState input = this.f_58857_.m_8055_(coords);
        ArrayList<WeightedEntry.Wrapper> values = new ArrayList<WeightedEntry.Wrapper>();
        for (OrechidRecipe orechidRecipe : OrechidManager.getMatchingRecipes(this.m_58904_().m_7465_(), this.getRecipeType(), input)) {
            values.add(WeightedEntry.m_146290_((Object)orechidRecipe, (int)orechidRecipe.getWeight(this.m_58904_(), coords)));
        }
        return WeightedRandom.m_216822_((RandomSource)this.m_58904_().f_46441_, values).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    private void trySetRecipe(BlockPos coords, @Nullable OrechidRecipe recipe) {
        if (recipe == null) {
            return;
        }
        BlockState state = recipe.getOutput(this.f_58857_, coords).pick(this.f_58857_.f_46441_);
        if (this.m_58904_().m_46597_(coords, state)) {
            if (BotaniaConfig.common().blockBreakParticles()) {
                this.m_58904_().m_46796_(2001, coords, Block.m_49956_((BlockState)state));
            }
            this.playSound(coords);
            this.addMana(-this.getCost());
            this.m_58904_().m_142346_(null, GameEvent.f_157792_, coords);
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            MinecraftServer server = serverLevel.m_7654_();
            recipe.getSuccessFunction().m_78002_(server.m_129890_()).ifPresent(command -> {
                CommandSourceStack context = server.m_129890_().m_136129_().m_81327_(serverLevel).m_81348_(Vec3.m_82539_((Vec3i)coords));
                server.m_129890_().m_136112_(command, context);
            });
            this.sync();
        }
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        Predicate<BlockState> matcher = this.getReplaceMatcher();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.getEffectivePos().m_7918_(-this.getRange(), -this.getRangeY(), -this.getRange()), (BlockPos)this.getEffectivePos().m_7918_(this.getRange(), this.getRangeY(), this.getRange()))) {
            BlockState state = this.m_58904_().m_8055_(pos);
            if (!matcher.test(state)) continue;
            possibleCoords.add(pos.m_7949_());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.m_58904_().f_46441_.m_188503_(possibleCoords.size()));
    }

    public boolean canOperate() {
        return true;
    }

    public RecipeType<? extends OrechidRecipe> getRecipeType() {
        return BotaniaRecipeTypes.ORECHID_TYPE;
    }

    public Predicate<BlockState> getReplaceMatcher() {
        return state -> !OrechidManager.getMatchingRecipes(this.m_58904_().m_7465_(), this.getRecipeType(), state).isEmpty();
    }

    public int getCost() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 700 : 17500;
    }

    public int getDelay() {
        return XplatAbstractions.INSTANCE.gogLoaded() ? 2 : 100;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getRange() {
        return 5;
    }

    public int getRangeY() {
        return 3;
    }

    @Override
    public int getColor() {
        return 0x818181;
    }

    @Override
    public int getMaxMana() {
        return this.getCost();
    }
}

