/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BotanicalBreweryRecipe
implements vazkii.botania.api.recipe.BotanicalBreweryRecipe {
    private final ResourceLocation id;
    private final Brew brew;
    private final NonNullList<Ingredient> inputs;

    public BotanicalBreweryRecipe(ResourceLocation id, Brew brew, Ingredient ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs);
    }

    public boolean m_5818_(Container inv, @NotNull Level world) {
        ItemStack stack;
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.m_6643_() && !(stack = inv.m_8020_(i)).m_41619_(); ++i) {
            if (stack.m_41720_() instanceof BrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                Ingredient input = (Ingredient)iter.next();
                if (!input.test(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BotaniaBlocks.brewery);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public ItemStack getOutput(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BrewContainer)) {
            return new ItemStack((ItemLike)Items.f_42590_);
        }
        BrewContainer container = (BrewContainer)item;
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof BotanicalBreweryRecipe)) return false;
        BotanicalBreweryRecipe brewRecipe = (BotanicalBreweryRecipe)o;
        if (this.brew != brewRecipe.brew) return false;
        if (!this.inputs.equals(brewRecipe.inputs)) return false;
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<BotanicalBreweryRecipe> {
        @NotNull
        public BotanicalBreweryRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            String brewStr = GsonHelper.m_13906_((JsonObject)json, (String)"brew");
            ResourceLocation brewId = ResourceLocation.m_135820_((String)brewStr);
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().m_6612_(brewId).orElseThrow(() -> new JsonParseException("Unknown brew " + brewStr));
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new BotanicalBreweryRecipe(id, brew, inputs.toArray(new Ingredient[0]));
        }

        public BotanicalBreweryRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            ResourceLocation brewId = buf.m_130281_();
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(brewId);
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            return new BotanicalBreweryRecipe(id, brew, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull BotanicalBreweryRecipe recipe) {
            ResourceLocation brewId = BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)recipe.getBrew());
            buf.m_130085_(brewId);
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
        }
    }
}

