/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.common.world.SkyblockWorldEvents;

public class SkyblockCommand {
    private static final SimpleCommandExceptionType NOT_SKYBLOCK_WORLD = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"botaniamisc.command.skyblock.world"));
    private static final SimpleCommandExceptionType NO_ISLAND = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"botaniamisc.command.skyblock.noisland"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"botania-skyblock").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"help").executes(SkyblockCommand::printHelp))).then(Commands.m_82127_((String)"island").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SkyblockCommand::createIsland)))).then(Commands.m_82127_((String)"spawn").executes(SkyblockCommand::teleportToSpawn))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"visit").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<CommandSourceStack>)ctx, (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))).then(Commands.m_82129_((String)"playerUuid", (ArgumentType)UuidArgument.m_113850_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(SkyblockSavedData.get((ServerLevel)((CommandSourceStack)ctx.getSource()).m_81372_()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<CommandSourceStack>)ctx, UuidArgument.m_113853_((CommandContext)ctx, (String)"playerUuid")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"regen-island").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player"))))).then(Commands.m_82129_((String)"playerUuid", (ArgumentType)UuidArgument.m_113850_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82981_(SkyblockSavedData.get((ServerLevel)((CommandSourceStack)ctx.getSource()).m_81372_()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<CommandSourceStack>)ctx, UuidArgument.m_113853_((CommandContext)ctx, (String)"playerUuid")))));
        LiteralCommandNode command = dispatcher.register(commandBuilder);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"gardenofglass").redirect((CommandNode)command));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"gog").redirect((CommandNode)command));
    }

    private static int printHelp(CommandContext<CommandSourceStack> ctx) {
        int i = 0;
        while (i < 5) {
            int finalI = i++;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)("botaniamisc.command.skyblock.help." + finalI)), false);
        }
        return 1;
    }

    private static int doTeleportToIsland(CommandContext<CommandSourceStack> ctx, UUID owner, Component feedback) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        return SkyblockCommand.doTeleportToIsland(ctx, player, owner, feedback);
    }

    private static int doTeleportToIsland(CommandContext<CommandSourceStack> ctx, ServerPlayer player, UUID owner, Component feedback) throws CommandSyntaxException {
        ServerLevel world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(owner, SkyblockSavedData.get(world));
        BlockPos blockPos = pos.getCenter();
        player.m_8999_(world, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> feedback, true);
        return 1;
    }

    private static int createIsland(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        SkyblockSavedData data = SkyblockSavedData.get(SkyblockCommand.getSkyblockWorld(ctx));
        UUID uuid = player.m_20148_();
        if (data.skyblocks.containsValue((Object)uuid)) {
            SkyblockCommand.doTeleportToIsland(ctx, player, uuid, (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.island.teleported", (Object[])new Object[]{((CommandSourceStack)ctx.getSource()).m_81357_()}));
            return 1;
        }
        SkyblockWorldEvents.spawnPlayer((Player)player, data.create(uuid));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"botaniamisc.command.skyblock.island.success", (Object[])new Object[]{player.m_5446_()}), true);
        return 1;
    }

    private static int doRebuildIsland(CommandContext<CommandSourceStack> ctx, UUID player, Component feedback) throws CommandSyntaxException {
        ServerLevel world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(player, SkyblockSavedData.get(world));
        SkyblockWorldEvents.createSkyblock(world, pos.getCenter());
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> feedback, true);
        return 1;
    }

    private static IslandPos getIslandForUUID(UUID player, SkyblockSavedData data) throws CommandSyntaxException {
        IslandPos pos = (IslandPos)data.skyblocks.inverse().get((Object)player);
        if (pos == null) {
            throw NO_ISLAND.create();
        }
        return pos;
    }

    private static ServerLevel getSkyblockWorld(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        if (!SkyblockChunkGenerator.isWorldSkyblock((Level)world)) {
            throw NOT_SKYBLOCK_WORLD.create();
        }
        return world;
    }

    private static int teleportToIsland(CommandContext<CommandSourceStack> ctx, Player owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner.m_20148_(), (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.teleport.success", (Object[])new Object[]{((CommandSourceStack)ctx.getSource()).m_81357_(), owner.m_7755_()}));
    }

    private static int teleportToIsland(CommandContext<CommandSourceStack> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner, (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.teleport.success", (Object[])new Object[]{((CommandSourceStack)ctx.getSource()).m_81357_(), owner}));
    }

    private static int teleportToSpawn(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, Util.f_137441_, (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.spawn.success", (Object[])new Object[]{((CommandSourceStack)ctx.getSource()).m_81357_()}));
    }

    private static int rebuildIsland(CommandContext<CommandSourceStack> ctx, ServerPlayer owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner.m_20148_(), (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.regenisland.success", (Object[])new Object[]{owner.m_5446_()}));
    }

    private static int rebuildIsland(CommandContext<CommandSourceStack> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner, (Component)Component.m_237110_((String)"botaniamisc.command.skyblock.regenisland.success", (Object[])new Object[]{owner}));
    }
}

