/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CocoonBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

public class CocoonBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = CocoonBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    protected CocoonBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity e) {
        if (!world.f_46443_ && e instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)e;
            ItemStack stack = item.m_32055_();
            this.addStack(world, pos, stack, false);
            if (stack.m_41619_()) {
                item.m_146870_();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        return this.addStack(world, pos, stack, player.m_150110_().f_35937_);
    }

    private InteractionResult addStack(Level world, BlockPos pos, ItemStack stack, boolean creative) {
        CocoonBlockEntity cocoon = (CocoonBlockEntity)world.m_7702_(pos);
        if (cocoon != null && (stack.m_150930_(Items.f_42616_) || stack.m_150930_(Items.f_42730_) || stack.m_150930_(BotaniaItems.lifeEssence))) {
            if (!world.f_46443_) {
                if (stack.m_150930_(Items.f_42616_) && cocoon.emeraldsGiven < 20) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    ++cocoon.emeraldsGiven;
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 1, 0.1, 0.05, 0.1, 0.5);
                } else if (stack.m_150930_(Items.f_42730_) && cocoon.chorusFruitGiven < 20) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    ++cocoon.chorusFruitGiven;
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 32, 0.0, 0.0, 0.0, 0.5);
                } else if (stack.m_150930_(BotaniaItems.lifeEssence) && !cocoon.gaiaSpiritGiven) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    cocoon.forceRare();
                    WispParticleData data = WispParticleData.wisp(0.6f, 0.0f, 1.0f, 0.0f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)data, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 8, 0.1, 0.1, 0.1, 0.04);
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CocoonBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CocoonBlock.createTickerHelper(type, BotaniaBlockEntities.COCOON, CocoonBlockEntity::commonTick);
    }
}

