/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class GaiaGuardianNoArmorTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("gaia_guardian_no_armor");
    public static final GaiaGuardianNoArmorTrigger INSTANCE = new GaiaGuardianNoArmorTrigger();

    private GaiaGuardianNoArmorTrigger() {
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, EntityPredicate.m_36614_((JsonElement)json.get("guardian")), DamageSourcePredicate.m_25451_((JsonElement)json.get("killing_blow")));
    }

    public void trigger(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
        this.m_66234_(player, instance -> instance.test(player, guardian, src));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate guardian;
        private final DamageSourcePredicate killingBlow;

        public Instance(ContextAwarePredicate playerPred, EntityPredicate count, DamageSourcePredicate indexPos) {
            super(ID, playerPred);
            this.guardian = count;
            this.killingBlow = indexPos;
        }

        @NotNull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
            return this.guardian.m_36611_(player, (Entity)guardian) && this.killingBlow.m_25448_(player, src);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.guardian != EntityPredicate.f_36550_) {
                json.add("guardian", this.guardian.m_36606_());
            }
            if (this.killingBlow != DamageSourcePredicate.f_25420_) {
                json.add("killing_blow", this.killingBlow.m_25443_());
            }
            return json;
        }

        public EntityPredicate getGuardian() {
            return this.guardian;
        }

        public DamageSourcePredicate getKillingBlow() {
            return this.killingBlow;
        }
    }
}

