/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.configdata;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class LooniumMobAttributeModifier {
    public static final Codec<LooniumMobAttributeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(mam -> mam.name), (App)BuiltInRegistries.f_256951_.m_194605_().fieldOf("attribute").forGetter(mam -> mam.attribute), (App)Codec.DOUBLE.fieldOf("amount").forGetter(mam -> mam.amount), (App)Codec.STRING.xmap(LooniumMobAttributeModifier::operationFromString, LooniumMobAttributeModifier::operationToString).fieldOf("operation").forGetter(mam -> mam.operation)).apply((Applicative)instance, LooniumMobAttributeModifier::new));
    private final String name;
    public final Attribute attribute;
    private final double amount;
    private final AttributeModifier.Operation operation;

    public LooniumMobAttributeModifier(String name, Attribute attribute, double amount, AttributeModifier.Operation operation) {
        this.name = name;
        this.attribute = attribute;
        this.amount = amount;
        this.operation = operation;
    }

    public AttributeModifier createAttributeModifier() {
        return new AttributeModifier(this.name, this.amount, this.operation);
    }

    private static String operationToString(AttributeModifier.Operation operation) {
        return switch (operation) {
            case AttributeModifier.Operation.ADDITION -> "addition";
            case AttributeModifier.Operation.MULTIPLY_BASE -> "multiply_base";
            case AttributeModifier.Operation.MULTIPLY_TOTAL -> "multiply_total";
            default -> throw new IllegalArgumentException("Unknown operation " + operation);
        };
    }

    private static AttributeModifier.Operation operationFromString(String operation) {
        return switch (operation) {
            case "addition" -> AttributeModifier.Operation.ADDITION;
            case "multiply_base" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "multiply_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> throw new JsonSyntaxException("Unknown attribute modifier operation " + operation);
        };
    }

    public String toString() {
        return "MobAttributeModifier{name='" + this.name + "', attribute=" + this.attribute + ", amount=" + this.amount + ", operation=" + this.operation + "}";
    }
}

