/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.serverbound.JumpPacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class CirrusAmuletItem
extends BaubleItem {
    private static final Set<Player> JUMPING_PLAYERS = Collections.newSetFromMap(new WeakHashMap());
    private static int timesJumped;
    private static boolean jumpDown;

    public CirrusAmuletItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        Proxy.INSTANCE.runOnClient(() -> () -> {
            if (living == Minecraft.m_91087_().f_91074_) {
                LocalPlayer playerSp = (LocalPlayer)living;
                if (playerSp.m_20096_()) {
                    timesJumped = 0;
                } else {
                    if (timesJumped == 0) {
                        timesJumped = 1;
                        jumpDown = true;
                    }
                    if (playerSp.f_108618_.f_108572_) {
                        if (!jumpDown && timesJumped < ((CirrusAmuletItem)stack.m_41720_()).getMaxAllowedJumps()) {
                            playerSp.m_6135_();
                            ClientXplatAbstractions.INSTANCE.sendToServer(JumpPacket.INSTANCE);
                            ++timesJumped;
                        }
                        jumpDown = true;
                    } else {
                        jumpDown = false;
                    }
                }
            }
        });
    }

    public static void setJumping(Player entity) {
        JUMPING_PLAYERS.add(entity);
    }

    public static boolean popJumping(Player entity) {
        if (entity.m_9236_().f_46443_) {
            return timesJumped > 0;
        }
        return JUMPING_PLAYERS.remove(entity);
    }

    public int getMaxAllowedJumps() {
        return 2;
    }

    public static class Renderer
    implements AccessoryRenderer {
        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean armor = !living.m_6844_(EquipmentSlot.CHEST).m_41619_();
            bipedModel.f_102810_.m_104299_(ms);
            ms.m_85837_(-0.3, 0.4, armor ? 0.05 : 0.12);
            ms.m_85841_(0.5f, -0.5f, -0.5f);
            BakedModel model = stack.m_150930_(BotaniaItems.superCloudPendant) ? MiscellaneousModels.INSTANCE.nimbusGem : MiscellaneousModels.INSTANCE.cirrusGem;
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110790_());
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_);
        }
    }
}

