/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.brew.BaseBrewItem;

public class MergeVialRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<MergeVialRecipe> SERIALIZER = new NoOpRecipeSerializer<MergeVialRecipe>(MergeVialRecipe::new);

    public MergeVialRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level worldIn) {
        int count = 0;
        Brew brew = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof BaseBrewItem)) {
                return false;
            }
            BaseBrewItem vial = (BaseBrewItem)item;
            if (brew == null) {
                brew = vial.getBrew(stack);
            } else if (brew != vial.getBrew(stack)) {
                return false;
            }
            ++count;
        }
        return count > 1;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack firstStack = ItemStack.f_41583_;
        BaseBrewItem brew = null;
        int swigs = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (brew == null) {
                firstStack = stack.m_41777_();
                brew = (BaseBrewItem)stack.m_41720_();
            }
            if ((swigs += brew.getSwigsLeft(stack)) < brew.getSwigs()) continue;
            swigs = brew.getSwigs();
            break;
        }
        ((BaseBrewItem)Objects.requireNonNull(brew)).setSwigsLeft(firstStack, swigs);
        return firstStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        boolean foundFirst = false;
        int swigs = 0;
        int maxSwigs = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            BaseBrewItem brew = (BaseBrewItem)stack.m_41720_();
            if (!foundFirst) {
                foundFirst = true;
                swigs = brew.getSwigsLeft(stack);
                maxSwigs = brew.getSwigs();
                continue;
            }
            if ((swigs += brew.getSwigsLeft(stack)) > maxSwigs) {
                brew.setSwigsLeft(stack, swigs - maxSwigs);
                swigs = maxSwigs;
                remaining.set(i, (Object)stack.m_41777_());
                continue;
            }
            remaining.set(i, (Object)brew.getBaseStack());
        }
        return remaining;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

