/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class RunicAltarProvider
extends BotaniaRecipeProvider {
    public RunicAltarProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "Botania runic altar recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        int costTier1 = 5200;
        int costTier2 = 8000;
        int costTier3 = 12000;
        Ingredient manaSteel = Ingredient.m_204132_(BotaniaTags.Items.INGOTS_MANASTEEL);
        Ingredient manaDiamond = Ingredient.m_204132_(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        Ingredient manaPowder = Ingredient.m_204132_(BotaniaTags.Items.DUSTS_MANA);
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("water"), new ItemStack((ItemLike)BotaniaItems.runeWater, 2), 5200, manaPowder, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50130_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42523_})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("fire"), new ItemStack((ItemLike)BotaniaItems.runeFire, 2), 5200, manaPowder, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42588_})));
        Ingredient stone = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_});
        Ingredient coalBlock = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50353_});
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("earth"), new ItemStack((ItemLike)BotaniaItems.runeEarth, 2), 5200, manaPowder, manaSteel, stone, coalBlock, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50072_, Blocks.f_50073_})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("air"), new ItemStack((ItemLike)BotaniaItems.runeAir, 2), 5200, manaPowder, manaSteel, Ingredient.m_204132_((TagKey)ItemTags.f_215867_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42402_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_})));
        Ingredient fire = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeFire});
        Ingredient water = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeWater});
        Ingredient earth = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeEarth});
        Ingredient air = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeAir});
        Ingredient sapling = Ingredient.m_204132_((TagKey)ItemTags.f_13180_);
        Ingredient leaves = Ingredient.m_204132_((TagKey)ItemTags.f_13143_);
        Ingredient sand = Ingredient.m_204132_((TagKey)ItemTags.f_13137_);
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("spring"), new ItemStack((ItemLike)BotaniaItems.runeSpring), 8000, water, fire, sapling, sapling, sapling, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("summer"), new ItemStack((ItemLike)BotaniaItems.runeSummer), 8000, earth, air, sand, sand, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("autumn"), new ItemStack((ItemLike)BotaniaItems.runeAutumn), 8000, fire, air, leaves, leaves, leaves, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("winter"), new ItemStack((ItemLike)BotaniaItems.runeWinter), 8000, water, earth, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50127_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50127_}), Ingredient.m_204132_((TagKey)ItemTags.f_13167_), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50145_})));
        Ingredient spring = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeSpring});
        Ingredient summer = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeSummer});
        Ingredient autumn = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeAutumn});
        Ingredient winter = Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.runeWinter});
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("mana"), new ItemStack((ItemLike)BotaniaItems.runeMana), 8000, manaSteel, manaSteel, manaSteel, manaSteel, manaSteel, Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.manaPearl})));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("lust"), new ItemStack((ItemLike)BotaniaItems.runeLust), 12000, manaDiamond, manaDiamond, summer, air));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("gluttony"), new ItemStack((ItemLike)BotaniaItems.runeGluttony), 12000, manaDiamond, manaDiamond, winter, fire));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("greed"), new ItemStack((ItemLike)BotaniaItems.runeGreed), 12000, manaDiamond, manaDiamond, spring, water));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("sloth"), new ItemStack((ItemLike)BotaniaItems.runeSloth), 12000, manaDiamond, manaDiamond, autumn, air));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("wrath"), new ItemStack((ItemLike)BotaniaItems.runeWrath), 12000, manaDiamond, manaDiamond, winter, earth));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("envy"), new ItemStack((ItemLike)BotaniaItems.runeEnvy), 12000, manaDiamond, manaDiamond, winter, water));
        consumer.accept(new FinishedRecipe(RunicAltarProvider.idFor("pride"), new ItemStack((ItemLike)BotaniaItems.runePride), 12000, manaDiamond, manaDiamond, summer, fire));
        consumer.accept(new FinishedHeadRecipe(RunicAltarProvider.idFor("head"), new ItemStack((ItemLike)Items.f_42680_), 22500, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42678_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{BotaniaItems.pixieDust}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42696_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42656_, Items.f_42615_}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_})));
    }

    private static ResourceLocation idFor(String s) {
        return ResourceLocationHelper.prefix("runic_altar/" + s);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack output;
        private final int mana;
        private final Ingredient[] inputs;

        protected FinishedRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            this.id = id;
            this.output = output;
            this.mana = mana;
            this.inputs = inputs;
        }

        public void m_7917_(JsonObject json) {
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingr : this.inputs) {
                ingredients.add(ingr.m_43942_());
            }
            json.addProperty("mana", (Number)this.mana);
            json.add("ingredients", (JsonElement)ingredients);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.RUNE_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    private static class FinishedHeadRecipe
    extends FinishedRecipe {
        private FinishedHeadRecipe(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
            super(id, output, mana, inputs);
        }

        @Override
        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.RUNE_HEAD_SERIALIZER;
        }
    }
}

