/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.configdata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;

public class LooniumMobEffectToApply {
    public static final Codec<LooniumMobEffectToApply> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("effect").forGetter(me -> me.effect), (App)ExtraCodecs.f_144629_.optionalFieldOf("duration", (Object)-1).forGetter(me -> me.duration), (App)Codec.intRange((int)0, (int)255).optionalFieldOf("amplifier", (Object)0).forGetter(me -> me.amplifier)).apply((Applicative)instance, LooniumMobEffectToApply::new));
    private final MobEffect effect;
    private final int duration;
    private final int amplifier;

    private LooniumMobEffectToApply(MobEffect effect, int duration, int amplifier) {
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public static Builder effect(MobEffect effect) {
        return new Builder(effect);
    }

    @NotNull
    public MobEffectInstance createMobEffectInstance() {
        return new MobEffectInstance(this.effect, this.duration, this.amplifier);
    }

    public String toString() {
        return "MobEffectToApply{effect=" + this.effect + ", duration=" + this.duration + ", amplifier=" + this.amplifier + "}";
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LooniumMobEffectToApply)) return false;
        LooniumMobEffectToApply that = (LooniumMobEffectToApply)obj;
        if (!Objects.equals(this.effect, that.effect)) return false;
        if (this.duration != that.duration) return false;
        if (this.amplifier != that.amplifier) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.duration, this.amplifier);
    }

    public static class Builder {
        private final MobEffect effect;
        private int duration = -1;
        private int amplifier = 0;

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder amplifier(int amplifier) {
            this.amplifier = amplifier;
            return this;
        }

        public LooniumMobEffectToApply build() {
            return new LooniumMobEffectToApply(this.effect, this.duration, this.amplifier);
        }
    }
}

