/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

public class TestingUtil {
    public static final String EMPTY_STRUCTURE = "fabric-gametest-api-v1:empty";

    @Contract(value="_,_,_ -> fail")
    public static void throwPositionedAssertion(GameTestHelper helper, BlockPos relativePos, Supplier<String> msg) {
        throw new GameTestAssertPosException(msg.get(), helper.m_177449_(relativePos), relativePos, helper.m_177436_());
    }

    @Contract(value="false,_ -> fail")
    public static void assertThat(boolean value, Supplier<String> message) {
        if (!value) {
            throw new GameTestAssertException(message.get());
        }
    }

    @Contract(value="_,_,false,_ -> fail")
    public static void assertAt(GameTestHelper helper, BlockPos relativePos, boolean value, Supplier<String> message) {
        if (!value) {
            TestingUtil.throwPositionedAssertion(helper, relativePos, message);
        }
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEquals(a, b, () -> "Expected " + a + " to equal " + b);
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertThat(Objects.equals(a, b), message);
    }

    public static void assertEqualsAt(GameTestHelper helper, BlockPos relativePos, @Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEqualsAt(helper, relativePos, a, b, () -> "Expected " + a + " to equal " + b);
    }

    public static void assertEqualsAt(GameTestHelper helper, BlockPos relativePos, @Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertAt(helper, relativePos, Objects.equals(a, b), message);
    }

    public static <T extends BlockEntity> T assertBlockEntity(GameTestHelper helper, BlockPos relativePos, BlockEntityType<T> type) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of type " + BuiltInRegistries.f_257049_.m_7981_((Object)type) + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, be.m_58903_() == type, () -> "Expected BlockEntity of type " + BuiltInRegistries.f_257049_.m_7981_((Object)type) + " but found " + BuiltInRegistries.f_257049_.m_7981_((Object)be.m_58903_()));
        return (T)be;
    }

    public static <T extends BlockEntity> T assertBlockEntity(GameTestHelper helper, BlockPos relativePos, Class<T> classs) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of class " + classs.getSimpleName() + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, classs.isAssignableFrom(be.getClass()), () -> "Expected BlockEntity to be an instance of " + classs.getSimpleName() + " but found " + be.getClass().getSimpleName());
        return (T)((BlockEntity)classs.cast(be));
    }

    public static BlockEntity assertAnyBlockEntity(GameTestHelper helper, BlockPos relativePos) {
        BlockEntity be = helper.m_177347_(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected any BlockEntity but found nothing");
        return be;
    }

    public static void useItemOn(GameTestHelper helper, Player player, InteractionHand hand, BlockPos pos) {
        BlockPos absolutePos = helper.m_177449_(pos);
        BlockHitResult result = new BlockHitResult(Vec3.m_82512_((Vec3i)absolutePos), Direction.NORTH, absolutePos, true);
        ItemStack stack = player.m_21120_(hand);
        UseOnContext useOnContext = new UseOnContext(player, hand, result);
        stack.m_41661_(useOnContext);
    }

    public static void bindWithWandOfTheForest(GameTestHelper helper, BlockPos first, BlockPos second) {
        Player player = helper.m_177368_();
        player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)BotaniaItems.twigWand));
        player.m_20260_(true);
        player.m_146884_(Vec3.m_82512_((Vec3i)first));
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, first);
        player.m_146884_(Vec3.m_82512_((Vec3i)second));
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, second);
    }

    public static void bindForceRelayTarget(GameTestHelper helper, BlockPos relayPos, BlockPos targetPos) {
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        data.mapping.put(helper.m_177449_(relayPos), helper.m_177449_(targetPos));
    }

    @Nullable
    public static BlockPos getBoundForceRelayTarget(GameTestHelper helper, BlockPos relayPos) {
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((Level)helper.m_177100_());
        return data.mapping.get(helper.m_177449_(relayPos));
    }

    public static void setUpSpreaderAndCompositeLens(GameTestHelper helper, Item firstLensType, Item secondLensType, BlockPos spreaderPos, BlockPos spreaderTargetPos) {
        ItemStack firstLensStack = new ItemStack((ItemLike)firstLensType);
        ItemStack secondLensStack = new ItemStack((ItemLike)secondLensType);
        ItemStack compositeLens = ((LensItem)firstLensStack.m_41720_()).setCompositeLens(firstLensStack, secondLensStack);
        ManaSpreaderBlockEntity spreaderEntity = TestingUtil.assertBlockEntity(helper, spreaderPos, BotaniaBlockEntities.SPREADER);
        spreaderEntity.getItemHandler().m_6836_(0, compositeLens);
        TestingUtil.bindWithWandOfTheForest(helper, spreaderPos, spreaderTargetPos);
    }
}

