/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class SpectranthemumBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private static final int BASE_COST = 2;
    private static final int RANGE = 2;
    private BlockPos bindPos = Bound.UNBOUND_POS;

    public SpectranthemumBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SPECTRANTHEMUM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.redstoneSignal == 0 && this.m_58904_().m_46805_(this.bindPos)) {
            BlockPos pos = this.getEffectivePos();
            boolean did = false;
            List items = this.m_58904_().m_45976_(ItemEntity.class, new AABB(pos.m_7918_(-2, -2, -2), pos.m_7918_(3, 3, 3)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!DelayHelper.canInteractWith(this, item) || XplatAbstractions.INSTANCE.findManaItem(stack = item.m_32055_()) != null) continue;
                double cost = (double)(2 * stack.m_41613_()) * Math.sqrt(this.bindPos.m_203193_((Position)item.m_20182_()));
                if (!((double)this.getMana() >= cost)) continue;
                SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item, 10);
                BlockPos sourcePos = item.m_20183_();
                item.m_6034_((double)this.bindPos.m_123341_() + 0.5, (double)this.bindPos.m_123342_() + 1.5, (double)this.bindPos.m_123343_() + 0.5);
                EntityHelper.addTeleportTicketIfFarAway((Entity)item, sourcePos);
                item.m_20256_(Vec3.f_82478_);
                SpectranthemumBlockEntity.spawnExplosionParticles((Entity)item, 10);
                this.addMana(-((int)cost));
                did = true;
            }
            if (did) {
                this.sync();
            }
        }
    }

    static void spawnExplosionParticles(Entity item, int p) {
        XplatAbstractions.INSTANCE.sendToTracking(item, new BotaniaEffectPacket(EffectType.ITEM_SMOKE, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_19879_(), p));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BIND_X, this.bindPos.m_123341_());
        cmp.m_128405_(TAG_BIND_Y, this.bindPos.m_123342_());
        cmp.m_128405_(TAG_BIND_Z, this.bindPos.m_123343_());
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.bindPos = new BlockPos(cmp.m_128451_(TAG_BIND_X), cmp.m_128451_(TAG_BIND_Y), cmp.m_128451_(TAG_BIND_Z));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getColor() {
        return 10009855;
    }

    @Override
    public int getMaxMana() {
        return 5000;
    }

    @Override
    public boolean bindTo(Player player, ItemStack wand, BlockPos pos, Direction side) {
        boolean bound = super.bindTo(player, wand, pos, side);
        if (!(bound || pos.equals((Object)this.bindPos) || pos.equals((Object)this.getEffectivePos()))) {
            this.bindPos = pos;
            this.sync();
            return true;
        }
        return bound;
    }

    @Override
    public BlockPos getBinding() {
        return Proxy.INSTANCE.getClientPlayer().m_6144_() && this.bindPos.m_123342_() != Integer.MIN_VALUE ? this.bindPos : super.getBinding();
    }
}

