/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class RenderLexicon {
    private static BookModel model = null;
    private static final boolean SHOULD_MISSPELL = Math.random() < 0.004;
    public static final Material TEXTURE = new Material(InventoryMenu.f_39692_, ResourceLocationHelper.prefix("item/lexicon_3d"));
    public static final Material ELVEN_TEXTURE = new Material(InventoryMenu.f_39692_, ResourceLocationHelper.prefix("item/lexicon_elven_3d"));
    private static final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    private static final String[] MISSPELLINGS = new String[]{"Bonito", "Bonita", "Bonitia", "Botnaia", "Bontonio", "Botnia", "Bonitaaaaaaaaaa", "Botonio", "Botonia", "Botnetia", "Banana", "Brotania", "Botanica", "Boat", "Batania", "Bosnia"};
    private static int quote = -1;
    private static int misspelling = -1;

    private static BookModel getModel() {
        if (model == null) {
            model = new BookModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171271_));
        }
        return model;
    }

    public static boolean renderHand(ItemStack stack, ItemDisplayContext type, boolean leftHanded, PoseStack ms, MultiBufferSource buffers, int light) {
        if (!BotaniaConfig.client().lexicon3dModel() || !type.m_269069_() || stack.m_41619_() || !stack.m_150930_((Item)BotaniaItems.lexicon)) {
            return false;
        }
        try {
            RenderLexicon.doRender(stack, leftHanded, ms, buffers, light, ClientTickHandler.partialTicks);
            return true;
        }
        catch (Throwable throwable) {
            BotaniaAPI.LOGGER.warn("Failed to render lexicon", throwable);
            return false;
        }
    }

    private static void doRender(ItemStack stack, boolean leftHanded, PoseStack ms, MultiBufferSource buffers, int light, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ms.m_85836_();
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = LexicaBotaniaItem.isOpen() ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        if (!leftHanded) {
            ms.m_252880_(0.3f + 0.02f * ticks, 0.125f + 0.01f * ticks, -0.2f - 0.035f * ticks);
            ms.m_252781_(VecHelper.rotateY(180.0f + ticks * 6.0f));
        } else {
            ms.m_252880_(0.1f - 0.02f * ticks, 0.125f + 0.01f * ticks, -0.2f - 0.035f * ticks);
            ms.m_252781_(VecHelper.rotateY(200.0f + ticks * 10.0f));
        }
        ms.m_252781_(VecHelper.rotateZ(-0.3f + ticks * 2.85f));
        float opening = Mth.m_14036_((float)(ticks / 12.0f), (float)0.0f, (float)1.0f);
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= ClientTickHandler.partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        float leftPageAngle = Mth.m_14187_((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
        float rightPageAngle = Mth.m_14187_((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
        BookModel model = RenderLexicon.getModel();
        model.m_102292_(ClientTickHandler.total(), Mth.m_14036_((float)leftPageAngle, (float)0.0f, (float)1.0f), Mth.m_14036_((float)rightPageAngle, (float)0.0f, (float)1.0f), opening);
        Material mat = LexicaBotaniaItem.isElven(stack) ? ELVEN_TEXTURE : TEXTURE;
        VertexConsumer buffer = mat.m_119194_(buffers, RenderType::m_110446_);
        model.m_7695_(ms, buffer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (ticks < 3.0f) {
            Font font = Minecraft.m_91087_().f_91062_;
            ms.m_252781_(VecHelper.rotateZ(180.0f));
            ms.m_252880_(-0.3f, -0.24f, -0.07f);
            ms.m_85841_(0.003f, 0.003f, -0.003f);
            if (misspelling == -1 && mc.f_91073_ != null) {
                misspelling = mc.f_91073_.f_46441_.m_188503_(MISSPELLINGS.length);
            }
            String title = LexicaBotaniaItem.getTitle(stack).getString();
            if (SHOULD_MISSPELL) {
                title = title.replaceAll("Botania", MISSPELLINGS[misspelling]);
            }
            font.m_271703_(font.m_92834_(title, 80), 0.0f, 0.0f, 14063360, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.m_252880_(0.0f, 10.0f, 0.0f);
            ms.m_85841_(0.6f, 0.6f, 0.6f);
            MutableComponent edition = LexicaBotaniaItem.getEdition().m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.BOLD});
            font.m_272077_((Component)edition, 0.0f, 0.0f, 10514688, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            if (quote == -1 && mc.f_91073_ != null) {
                quote = mc.f_91073_.f_46441_.m_188503_(QUOTES.length);
            }
            String quoteStr = QUOTES[quote];
            ms.m_252880_(-5.0f, 15.0f, 0.0f);
            RenderLexicon.renderText(0, 0, 140, 0, 7995282, quoteStr, ms.m_85850_().m_252922_(), buffers, light);
            ms.m_252880_(8.0f, 110.0f, 0.0f);
            String blurb = I18n.m_118938_((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]);
            font.m_271703_(blurb, 0.0f, 0.0f, 7995282, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.m_252880_(0.0f, 10.0f, 0.0f);
            String blurb2 = ChatFormatting.UNDERLINE + ChatFormatting.ITALIC + I18n.m_118938_((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]);
            font.m_271703_(blurb2, 0.0f, 0.0f, 7995282, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
            ms.m_252880_(0.0f, -30.0f, 0.0f);
            String authorTitle = I18n.m_118938_((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.m_92895_(authorTitle);
            font.m_271703_(authorTitle, 58.0f - (float)len / 2.0f, -8.0f, 14063360, false, ms.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, light);
        }
        ms.m_85849_();
    }

    private static void renderText(int x, int y, int width, int paragraphSize, int color, String unlocalizedText, Matrix4f matrix, MultiBufferSource buffers, int light) {
        x += 2;
        y += 10;
        width -= 4;
        Font font = Minecraft.m_91087_().f_91062_;
        String text = I18n.m_118938_((String)unlocalizedText, (Object[])new Object[0]).replaceAll("&", "\u00a7");
        String[] textEntries = text.split("<br>");
        ArrayList lines = new ArrayList();
        for (String s : textEntries) {
            String[] tokens;
            ArrayList<CallSite> words = new ArrayList<CallSite>();
            Object lineStr = "";
            for (String token : tokens = s.split(" ")) {
                String prev = lineStr;
                String spaced = token + " ";
                lineStr = (String)lineStr + spaced;
                String controlCodes = RenderLexicon.toControlCodes(RenderLexicon.getControlCodes(prev));
                if (font.m_92895_((String)lineStr) > width) {
                    lines.add(words);
                    lineStr = controlCodes + spaced;
                    words = new ArrayList();
                }
                words.add((CallSite)((Object)(controlCodes + token)));
            }
            if (!((String)lineStr).isEmpty()) {
                lines.add(words);
            }
            lines.add(new ArrayList());
        }
        for (List list : lines) {
            int xi = x;
            int spacing = 4;
            for (String s : list) {
                int extra = 0;
                font.m_271703_(s, (float)xi, (float)y, color, false, matrix, buffers, Font.DisplayMode.NORMAL, 0, light);
                xi += font.m_92895_(s) + spacing + extra;
            }
            y += list.isEmpty() ? paragraphSize : 10;
        }
    }

    private static String getControlCodes(String s) {
        String controls = s.replaceAll("(?<!\u00a7)(.)", "");
        return controls.replaceAll(".*r", "r");
    }

    private static String toControlCodes(String s) {
        return s.replaceAll(".", "\u00a7$0");
    }
}

