/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.IncensePlateBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class IncensePlateBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape X_SHAPE = IncensePlateBlock.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)1.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = IncensePlateBlock.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0);

    protected IncensePlateBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        IncensePlateBlockEntity plate = (IncensePlateBlockEntity)world.m_7702_(pos);
        ItemStack plateStack = plate.getItemHandler().m_8020_(0);
        ItemStack stack = player.m_21120_(hand);
        boolean did = false;
        if (plateStack.m_41619_() && plate.acceptsItem(stack)) {
            plate.getItemHandler().m_6836_(0, stack.m_41777_());
            world.m_142346_(null, GameEvent.f_157792_, pos);
            stack.m_41774_(1);
            did = true;
        } else if (!plateStack.m_41619_() && !plate.burning) {
            if (XplatAbstractions.INSTANCE.canToolLightFire(stack)) {
                plate.ignite();
                world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
            } else if (stack.m_150930_(Items.f_42613_)) {
                plate.ignite();
                RandomSource randomsource = world.m_213780_();
                world.m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (randomsource.m_188501_() - randomsource.m_188501_()) * 0.2f + 1.0f);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            } else {
                player.m_150109_().m_150079_(plateStack);
                plate.getItemHandler().m_6836_(0, ItemStack.f_41583_);
                world.m_142346_(null, GameEvent.f_157792_, pos);
            }
            did = true;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
            plate.m_6596_();
        }
        return did ? InteractionResult.m_19078_((boolean)world.m_5776_()) : InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return ((IncensePlateBlockEntity)world.m_7702_((BlockPos)pos)).comparatorOutput;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == Direction.Axis.X) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new IncensePlateBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return IncensePlateBlock.createTickerHelper(type, BotaniaBlockEntities.INCENSE_PLATE, IncensePlateBlockEntity::commonTick);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity block;
        if (!state.m_60713_(newState.m_60734_()) && (block = world.m_7702_(pos)) instanceof IncensePlateBlockEntity) {
            IncensePlateBlockEntity plate = (IncensePlateBlockEntity)block;
            if (!plate.burning) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)plate.getItemHandler());
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_5581_(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && projectile.m_142265_(level, hit.m_82425_()) && projectile.m_6060_() && (blockEntity = level.m_7702_(hit.m_82425_())) instanceof IncensePlateBlockEntity) {
            IncensePlateBlockEntity plate = (IncensePlateBlockEntity)blockEntity;
            plate.ignite();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
    }
}

