/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.network.clientbound.GogWorldPacket;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class SkyblockWorldEvents {
    private static final TagKey<Block> PEBBLE_SOURCES = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("gardenofglass:pebble_sources"));
    private static final ResourceLocation PEBBLES_TABLE = new ResourceLocation("gardenofglass", "pebbles");

    private SkyblockWorldEvents() {
    }

    public static void syncGogStatus(ServerPlayer e) {
        boolean isGog = SkyblockChunkGenerator.isWorldSkyblock(e.m_9236_());
        if (isGog) {
            XplatAbstractions.INSTANCE.sendToPlayer((Player)e, GogWorldPacket.INSTANCE);
        }
    }

    public static void onPlayerJoin(ServerPlayer player) {
        ServerLevel world = player.m_284548_();
        if (SkyblockChunkGenerator.isWorldSkyblock((Level)world)) {
            SkyblockSavedData data = SkyblockSavedData.get(world);
            if (!data.skyblocks.containsValue((Object)Util.f_137441_)) {
                IslandPos islandPos = data.getSpawn();
                world.m_8733_(islandPos.getCenter(), 0.0f);
                SkyblockWorldEvents.spawnPlayer((Player)player, islandPos);
                BotaniaAPI.LOGGER.info("Created the spawn GoG island");
            }
        }
    }

    public static InteractionResult onPlayerInteract(Player player, Level world, InteractionHand hand, BlockHitResult hit) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            BlockPos pos;
            BlockHitResult rtr;
            ItemStack equipped = player.m_21120_(hand);
            if (equipped.m_41619_() && player.m_6144_()) {
                BlockState state = world.m_8055_(hit.m_82425_());
                if (state.m_204336_(PEBBLE_SOURCES)) {
                    SoundType st = state.m_60827_();
                    SoundEvent sound = st.m_56775_();
                    player.m_5496_(sound, st.m_56773_() * 0.4f, st.m_56774_() + (float)(Math.random() * 0.2 - 0.1));
                    if (world.f_46443_) {
                        player.m_6674_(hand);
                    } else if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        LootTable table = level.m_7654_().m_278653_().m_278676_(PEBBLES_TABLE);
                        LootParams context = new LootParams.Builder(level).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)hit.m_82425_())).m_287286_(LootContextParams.f_81463_, (Object)equipped).m_287286_(LootContextParams.f_81455_, (Object)player).m_287289_(LootContextParams.f_81462_, (Object)level.m_7702_(hit.m_82425_())).m_287235_(LootContextParamSets.f_81421_);
                        table.m_287228_(context, s -> player.m_36176_(s, false));
                    }
                    return InteractionResult.SUCCESS;
                }
            } else if (!equipped.m_41619_() && equipped.m_150930_(Items.f_42399_) && (rtr = ToolCommons.raytraceFromEntity((Entity)player, 4.5, true)).m_6662_() == HitResult.Type.BLOCK && world.m_8055_(pos = rtr.m_82425_()).m_60713_(Blocks.f_49990_)) {
                if (!world.f_46443_) {
                    equipped.m_41774_(1);
                    if (equipped.m_41619_()) {
                        player.m_21008_(hand, new ItemStack((ItemLike)BotaniaItems.waterBowl));
                    } else {
                        player.m_150109_().m_150079_(new ItemStack((ItemLike)BotaniaItems.waterBowl));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void spawnPlayer(Player player, IslandPos islandPos) {
        BlockPos pos = islandPos.getCenter();
        if (player instanceof ServerPlayer) {
            ServerPlayer pmp = (ServerPlayer)player;
            SkyblockWorldEvents.createSkyblock(pmp.m_284548_(), pos);
            pmp.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.6, (double)pos.m_123343_() + 0.5);
            pmp.m_9158_(pmp.m_9236_().m_46472_(), pos, 0.0f, true, false);
            if (BotaniaConfig.common().gogSpawnWithLexicon()) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)BotaniaItems.lexicon));
            }
        }
    }

    public static void createSkyblock(ServerLevel level, BlockPos pos) {
        BlockPos offset;
        StructureTemplateManager manager = level.m_215082_();
        StructureTemplate template = (StructureTemplate)manager.m_230407_(ResourceLocationHelper.prefix("gog_island")).orElseThrow();
        ObjectArrayList structureBlockInfos = template.m_230335_(pos, new StructurePlaceSettings(), Blocks.f_50677_, false);
        structureBlockInfos.removeIf(info -> info.f_74677_() == null);
        Optional<StructureTemplate.StructureBlockInfo> infoOptional = structureBlockInfos.stream().filter(info -> "spawn_point".equals(info.f_74677_().m_128461_("metadata"))).findFirst();
        if (infoOptional.isPresent()) {
            offset = infoOptional.get().f_74675_();
        } else {
            BotaniaAPI.LOGGER.error("Structure botania:gog_island has no spawn_point data marker block, trying to offset it somewhat in the center");
            Vec3i size = template.m_163801_();
            offset = new BlockPos(size.m_123341_() / 2, size.m_123342_(), size.m_123343_() / 2);
        }
        BlockPos startPoint = pos.m_121996_((Vec3i)offset);
        template.m_230328_((ServerLevelAccessor)level, startPoint, startPoint, new StructurePlaceSettings().m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_), level.f_46441_, 3);
        for (StructureTemplate.StructureBlockInfo info2 : structureBlockInfos) {
            BlockPos lightPos;
            if (!"light".equals(info2.f_74677_().m_128461_("metadata")) || !level.m_46597_(lightPos = startPoint.m_121955_((Vec3i)info2.f_74675_()), BotaniaBlocks.manaFlame.m_49966_())) continue;
            int r = 70 + level.f_46441_.m_188503_(185);
            int g = 70 + level.f_46441_.m_188503_(185);
            int b = 70 + level.f_46441_.m_188503_(185);
            int color = r << 16 | g << 8 | b;
            ((ManaFlameBlockEntity)level.m_7702_(lightPos)).setColor(color);
        }
    }
}

