/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.xplat.XplatAbstractions;

public class RedirectiveLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        BlockPos sourcePos = burst.getBurstSourceBlockPos();
        ThrowableProjectile burstEntity = burst.entity();
        if (!burstEntity.m_9236_().f_46443_ && !burst.isFake()) {
            EntityHitResult result;
            BlockHitResult result2;
            if (pos instanceof BlockHitResult && (result2 = (BlockHitResult)pos).m_6662_() != HitResult.Type.MISS && !result2.m_82425_().equals((Object)sourcePos)) {
                this.handleHitBlock(burst, result2);
            } else if (pos instanceof EntityHitResult && (result = (EntityHitResult)pos).m_82443_() != burstEntity.m_19749_()) {
                this.handleHitEntity(burst, result);
            }
        }
        return shouldKill;
    }

    @Nullable
    private static Vec3 getSourceVec(ManaBurst burst) {
        ThrowableProjectile entity = burst.entity();
        Entity owner = entity.m_19749_();
        BlockPos sourcePos = burst.getBurstSourceBlockPos();
        if (!sourcePos.equals((Object)ManaBurst.NO_SOURCE)) {
            Vec3 sourceVec = Vec3.m_82512_((Vec3i)sourcePos);
            VoxelShape collideShape = entity.m_9236_().m_8055_(sourcePos).m_60812_((BlockGetter)entity.m_9236_(), sourcePos);
            AABB axis = collideShape.m_83281_() ? new AABB(sourcePos, sourcePos.m_7918_(1, 1, 1)) : collideShape.m_83215_().m_82338_(sourcePos);
            if (!axis.m_82390_(sourceVec)) {
                sourceVec = new Vec3(axis.f_82288_ + (axis.f_82291_ - axis.f_82288_) / 2.0, axis.f_82289_ + (axis.f_82292_ - axis.f_82289_) / 2.0, axis.f_82290_ + (axis.f_82293_ - axis.f_82290_) / 2.0);
            }
            return sourceVec;
        }
        if (owner != null) {
            return owner.m_146892_();
        }
        return null;
    }

    private void handleHitEntity(ManaBurst burst, EntityHitResult result) {
        Vec3 sourceVec = RedirectiveLens.getSourceVec(burst);
        if (sourceVec != null) {
            result.m_82443_().m_7618_(EntityAnchorArgument.Anchor.EYES, sourceVec);
        }
    }

    private void handleHitBlock(ManaBurst burst, BlockHitResult result) {
        Vec3 sourceVec = RedirectiveLens.getSourceVec(burst);
        if (sourceVec == null) {
            return;
        }
        ThrowableProjectile entity = burst.entity();
        BlockPos hitPos = result.m_82425_();
        ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(entity.m_9236_(), hitPos, result.m_82434_());
        if (receiver instanceof ManaSpreader) {
            ManaSpreader spreader = (ManaSpreader)receiver;
            Vec3 tileVec = Vec3.m_82512_((Vec3i)hitPos);
            Vec3 diffVec = sourceVec.m_82546_(tileVec);
            Vec3 diffVec2D = new Vec3(diffVec.f_82479_, diffVec.f_82481_, 0.0);
            Vec3 rotVec = new Vec3(0.0, 1.0, 0.0);
            double angle = MathHelper.angleBetween(rotVec, diffVec2D) / Math.PI * 180.0;
            if (sourceVec.f_82479_ < tileVec.f_82479_) {
                angle = -angle;
            }
            spreader.setRotationX((float)angle + 90.0f);
            rotVec = new Vec3(diffVec.f_82479_, 0.0, diffVec.f_82481_);
            angle = MathHelper.angleBetween(diffVec, rotVec) * 180.0 / Math.PI;
            if (sourceVec.f_82480_ < tileVec.f_82480_) {
                angle = -angle;
            }
            spreader.setRotationY((float)angle);
            spreader.commitRedirection();
            if (spreader instanceof ThrottledPacket) {
                ThrottledPacket pkt = (ThrottledPacket)((Object)spreader);
                pkt.markDispatchable();
            }
        }
    }
}

