/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.BlockProviderHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.RingOfLokiItem;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.xplat.XplatAbstractions;

public class AstrolabeItem
extends Item {
    public static final String TAG_BLOCKSTATE = "blockstate";
    public static final String TAG_SIZE = "size";
    public static final int BASE_COST = 320;

    public AstrolabeItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        BlockState state = ctx.m_43725_().m_8055_(ctx.m_8083_());
        Player player = ctx.m_43723_();
        if (player != null && player.m_36341_()) {
            if (AstrolabeItem.setBlock(stack, state)) {
                this.displayRemainderCounter(player, stack);
                return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
            }
        } else if (player != null) {
            boolean did = this.placeAllBlocks(stack, player, ctx.m_43724_());
            if (did) {
                this.displayRemainderCounter(player, stack);
            }
            return did ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @NotNull InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (playerIn.m_36341_()) {
            playerIn.m_5496_(BotaniaSounds.astrolabeConfigure, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                int size = AstrolabeItem.getSize(stack);
                int newSize = size == 11 ? 3 : size + 2;
                AstrolabeItem.setSize(stack, newSize);
                ItemsRemainingRenderHandler.send(playerIn, stack, 0, (Component)Component.m_237113_((String)(newSize + "x" + newSize)));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean placeAllBlocks(ItemStack requester, Player player, InteractionHand hand) {
        Block blockToPlace = AstrolabeItem.getBlock(requester, (HolderGetter<Block>)player.m_9236_().m_246945_(Registries.f_256747_));
        int size = AstrolabeItem.getSize(requester);
        BlockPlaceContext ctx = AstrolabeItem.getBlockPlaceContext(player, hand, blockToPlace);
        List<BlockPos> placePositions = AstrolabeItem.getPlacePositions(ctx, size);
        List<BlockProvider> blockProviders = AstrolabeItem.findBlockProviders(requester, player, placePositions.size(), blockToPlace);
        if (ctx == null || blockProviders.isEmpty()) {
            return false;
        }
        int cost = size * 320;
        if (!ManaItemHandler.instance().requestManaExact(requester, player, cost, true)) {
            return false;
        }
        for (BlockPos coords : placePositions) {
            if (!this.placeBlockAndConsume(requester, blockToPlace, ctx, coords, blockProviders)) break;
        }
        return true;
    }

    private boolean placeBlockAndConsume(ItemStack requester, Block blockToPlace, BlockPlaceContext ctx, BlockPos pos, List<BlockProvider> providers) {
        Player player = ctx.m_43723_();
        if (player == null) {
            return false;
        }
        BlockState state = blockToPlace.m_5573_(ctx);
        if (state == null) {
            return true;
        }
        if (providers.stream().noneMatch(prov -> prov.provideBlock(player, requester, blockToPlace, false))) {
            return false;
        }
        UseOnContext useOnContext = RingOfLokiItem.getUseOnContext(player, ctx.m_43724_(), pos, ctx.m_43720_(), ctx.m_43719_());
        if (!PlayerHelper.substituteUse(useOnContext, new ItemStack((ItemLike)blockToPlace)).m_19077_()) {
            return true;
        }
        for (BlockProvider prov2 : providers) {
            if (prov2.provideBlock(player, requester, blockToPlace, true)) break;
        }
        return true;
    }

    public static boolean hasBlocks(ItemStack requester, Player player, int required, Block block) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        return !AstrolabeItem.findBlockProviders(requester, player, required, block).isEmpty();
    }

    public static List<BlockProvider> findBlockProviders(ItemStack requester, Player player, int required, Block block) {
        if (block == Blocks.f_50016_ || required == 0) {
            return List.of();
        }
        if (player.m_150110_().f_35937_) {
            return List.of(BlockProviderHelper.asInfiniteBlockProvider(new ItemStack((ItemLike)block)));
        }
        int current = 0;
        ArrayList<BlockProvider> providersToCheck = new ArrayList<BlockProvider>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            int count;
            ItemStack stackInSlot = player.m_150109_().m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_150930_(block.m_5456_())) {
                current += stackInSlot.m_41613_();
                BlockProvider stackProvider = BlockProviderHelper.asBlockProvider(stackInSlot);
                providersToCheck.add(stackProvider);
                continue;
            }
            BlockProvider provider = XplatAbstractions.INSTANCE.findBlockProvider(stackInSlot);
            if (provider == null || (count = provider.getBlockCount(player, requester, block)) == 0) continue;
            current += count;
            providersToCheck.add(provider);
        }
        return current >= required ? providersToCheck : List.of();
    }

    @Nullable
    public static BlockPlaceContext getBlockPlaceContext(Player player, InteractionHand hand, Block blockToPlace) {
        if (blockToPlace == Blocks.f_50016_) {
            return null;
        }
        Attribute reachAttribute = XplatAbstractions.INSTANCE.getReachDistanceAttribute();
        double bonusReach = reachAttribute != null ? player.m_21133_(reachAttribute) : 0.0;
        BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 5.0 + bonusReach, false);
        return rtr.m_6662_() == HitResult.Type.BLOCK ? new BlockPlaceContext(player, hand, new ItemStack((ItemLike)blockToPlace.m_5456_()), rtr) : null;
    }

    public static List<BlockPos> getPlacePositions(BlockPlaceContext ctx, int size) {
        if (ctx == null || ctx.m_43723_() == null) {
            return List.of();
        }
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        BlockPos pos = ctx.m_8083_();
        BlockState clickedState = ctx.m_43725_().m_8055_(pos);
        if (clickedState.m_247087_() || clickedState.m_60629_(ctx)) {
            pos = pos.m_121945_(ctx.m_43719_().m_122424_());
        }
        int range = (size ^ 1) / 2;
        Direction dir = ctx.m_43719_();
        Direction rotationDir = Direction.m_122364_((double)ctx.m_43723_().m_146908_());
        boolean pitchedVertically = Math.abs(ctx.m_43723_().m_146909_()) > 50.0f;
        boolean axisX = rotationDir.m_122434_() == Direction.Axis.X;
        boolean axisZ = rotationDir.m_122434_() == Direction.Axis.Z;
        int xOff = axisZ || pitchedVertically ? range : 0;
        int yOff = pitchedVertically ? 0 : range;
        int zOff = axisX || pitchedVertically ? range : 0;
        for (int x = -xOff; x < xOff + 1; ++x) {
            for (int y = 0; y < yOff * 2 + 1; ++y) {
                for (int z = -zOff; z < zOff + 1; ++z) {
                    int xp = pos.m_123341_() + x + dir.m_122429_();
                    int yp = pos.m_123342_() + y + dir.m_122430_();
                    int zp = pos.m_123343_() + z + dir.m_122431_();
                    BlockPos newPos = new BlockPos(xp, yp, zp);
                    BlockState state = ctx.m_43725_().m_8055_(newPos);
                    if (!ctx.m_43725_().m_6857_().m_61937_(newPos) || !state.m_60795_() && !state.m_247087_() && !state.m_60629_(ctx)) continue;
                    coords.add(newPos);
                }
            }
        }
        return coords;
    }

    public void displayRemainderCounter(Player player, ItemStack stack) {
        Block block = AstrolabeItem.getBlock(stack, (HolderGetter<Block>)player.m_9236_().m_246945_(Registries.f_256747_));
        int count = ShiftingCrustRodItem.getInventoryItemCount(player, stack, block.m_5456_());
        if (!player.m_9236_().f_46443_) {
            ItemsRemainingRenderHandler.send(player, new ItemStack((ItemLike)block), count);
        }
    }

    public static boolean setBlock(ItemStack stack, BlockState state) {
        if (!state.m_60795_()) {
            ItemNBTHelper.setCompound(stack, TAG_BLOCKSTATE, NbtUtils.m_129202_((BlockState)state.m_60734_().m_49966_()));
            return true;
        }
        return false;
    }

    public static void setSize(ItemStack stack, int size) {
        ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
    }

    public static int getSize(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
    }

    public static Block getBlock(ItemStack stack, HolderGetter<Block> holderGetter) {
        return AstrolabeItem.getBlockState(stack, holderGetter).m_60734_();
    }

    public static BlockState getBlockState(ItemStack stack, HolderGetter<Block> holderGetter) {
        return NbtUtils.m_247651_(holderGetter, (CompoundTag)ItemNBTHelper.getCompound(stack, TAG_BLOCKSTATE, false));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tip, TooltipFlag flags) {
        if (level == null) {
            return;
        }
        Block block = AstrolabeItem.getBlock(stack, (HolderGetter<Block>)level.m_246945_(Registries.f_256747_));
        int size = AstrolabeItem.getSize(stack);
        tip.add((Component)Component.m_237113_((String)(size + " x " + size)));
        if (block != Blocks.f_50016_) {
            tip.add((Component)new ItemStack((ItemLike)block).m_41786_().m_6879_().m_130940_(ChatFormatting.GRAY));
        }
    }
}

