/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.mixin.BundleItemAccessor;

public class FilterHelper {
    public static final String ITEMS_TAG = "Items";

    public static List<ItemStack> getFilterItems(ItemFrame filterFrame) {
        ItemStack filterStack = filterFrame.m_31822_();
        if (filterStack.m_41619_()) {
            return List.of();
        }
        return filterFrame instanceof GlowItemFrame ? FilterHelper.getFilterStacks(filterStack) : List.of(filterStack);
    }

    public static List<ItemStack> getFilterStacks(ItemStack filterStack) {
        if (filterStack.m_150930_(Items.f_151058_)) {
            List<ItemStack> bundledItems = BundleItemAccessor.call_getContents(filterStack).toList();
            if (!bundledItems.isEmpty()) {
                return bundledItems;
            }
        } else {
            List<ItemStack> items;
            CompoundTag tag;
            CompoundTag compoundTag = tag = filterStack.m_41720_() instanceof BlockItem ? BlockItem.m_186336_((ItemStack)filterStack) : filterStack.m_41783_();
            if (tag != null && tag.m_128425_(ITEMS_TAG, 9) && (items = FilterHelper.getItemStacks(tag)) != null) {
                return items;
            }
        }
        return List.of(filterStack);
    }

    @Nullable
    private static List<ItemStack> getItemStacks(CompoundTag tag) {
        try {
            ListTag contents = tag.m_128437_(ITEMS_TAG, 10);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(contents.size());
            for (int i = 0; i < contents.size(); ++i) {
                CompoundTag entry = contents.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)entry);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
            if (!items.isEmpty()) {
                return items;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public record WeightedItemStack(ItemStack stack, Weight weight) implements WeightedEntry
    {
        public static WeightedItemStack of(ItemStack stack, int weight) {
            return new WeightedItemStack(stack, Weight.m_146282_((int)weight));
        }

        @NotNull
        public Weight m_142631_() {
            return this.weight;
        }
    }
}

