/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.commands.CommandFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.OrechidRecipe;

public class MarimorphosisRecipe
extends OrechidRecipe {
    private final int weightBonus;
    private final TagKey<Biome> biomes;

    public MarimorphosisRecipe(ResourceLocation id, StateIngredient input, StateIngredient output, int weight, CommandFunction.CacheableFunction successFunction, int weightBonus, TagKey<Biome> biomes) {
        super(id, input, output, weight, successFunction);
        this.weightBonus = weightBonus;
        this.biomes = biomes;
    }

    @Override
    public int getWeight(@NotNull Level level, @NotNull BlockPos pos) {
        if (level.m_204166_(pos).m_203656_(this.biomes)) {
            return this.getWeight() + this.weightBonus;
        }
        return this.getWeight();
    }

    @NotNull
    public RecipeType<? extends MarimorphosisRecipe> m_6671_() {
        return BotaniaRecipeTypes.MARIMORPHOSIS_TYPE;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.MARIMORPHOSIS_SERIALIZER;
    }

    public int getWeightBonus() {
        return this.weightBonus;
    }

    public TagKey<Biome> getBiomes() {
        return this.biomes;
    }

    public static class Serializer
    implements RecipeSerializer<MarimorphosisRecipe> {
        public MarimorphosisRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            OrechidRecipe base = (OrechidRecipe)BotaniaRecipeTypes.ORECHID_SERIALIZER.m_6729_(recipeId, json);
            TagKey biomes = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"biome_bonus_tag")));
            int weightBonus = GsonHelper.m_13824_((JsonObject)json, (String)"biome_bonus", (int)0);
            if (base.getWeight() + weightBonus <= 0) {
                throw new JsonSyntaxException("Weight combined with bonus cannot be 0 or less");
            }
            return new MarimorphosisRecipe(recipeId, base.getInput(), base.getOutput(), base.getWeight(), base.getSuccessFunction(), weightBonus, (TagKey<Biome>)biomes);
        }

        public MarimorphosisRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            OrechidRecipe base = (OrechidRecipe)BotaniaRecipeTypes.ORECHID_SERIALIZER.m_8005_(recipeId, buffer);
            TagKey biomes = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)buffer.m_130281_());
            int weightBonus = buffer.m_130242_();
            return new MarimorphosisRecipe(recipeId, base.getInput(), base.getOutput(), base.getWeight(), base.getSuccessFunction(), weightBonus, (TagKey<Biome>)biomes);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull MarimorphosisRecipe recipe) {
            BotaniaRecipeTypes.ORECHID_SERIALIZER.m_6178_(buffer, (Recipe)recipe);
            buffer.m_130085_(recipe.biomes.f_203868_());
            buffer.m_130130_(recipe.weightBonus);
        }
    }
}

