/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.AvatarSkiesRodPacket;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class SkiesRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_tornado.png");
    private static final int FLY_TIME = 20;
    private static final int FALL_MULTIPLIER = 3;
    private static final int MAX_COUNTER = 60;
    private static final int COST = 350;
    private static final String TAG_FLYING = "flying";
    private static final String TAG_FLYCOUNTER = "flyCounter";

    public SkiesRodItem(Item.Properties props) {
        super(props);
    }

    public void m_6883_(ItemStack stack, Level world, Entity ent, int slot, boolean active) {
        if (ent instanceof Player) {
            boolean held;
            Player player = (Player)ent;
            boolean damaged = this.getFlyCounter(stack) > 0;
            boolean bl = held = player.m_21205_() == stack || player.m_21206_() == stack;
            if (damaged && !SkiesRodItem.isFlying(stack)) {
                this.setFlyCounter(stack, this.getFlyCounter(stack) - 1);
            }
            if (this.getFlyCounter(stack) >= 60) {
                this.setFlying(stack, false);
            } else if (SkiesRodItem.isFlying(stack)) {
                if (held) {
                    player.f_19789_ = 0.0f;
                    double my = ManaItemHandler.instance().hasProficiency(player, stack) ? 1.6 : 1.25;
                    Vec3 oldMot = player.m_20184_();
                    if (player.m_21255_()) {
                        double boost = my * 1.2;
                        Vec3 lookDir = player.m_20154_();
                        player.m_20256_(oldMot.m_82520_(lookDir.f_82479_ * 0.1 + (lookDir.f_82479_ * boost - oldMot.f_82479_) * 0.5, lookDir.f_82480_ * 0.1 + (lookDir.f_82480_ * boost - oldMot.f_82480_) * 0.5, lookDir.f_82481_ * 0.1 + (lookDir.f_82481_ * boost - oldMot.f_82481_) * 0.5));
                    } else {
                        player.m_20256_(new Vec3(oldMot.m_7096_(), my, oldMot.m_7094_()));
                    }
                    player.m_5496_(BotaniaSounds.airRod, 1.0f, 1.0f);
                    if (this.getFlyCounter(stack) % 3 == 0) {
                        player.m_146850_(GameEvent.f_157815_);
                    }
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data = WispParticleData.wisp(0.35f + (float)Math.random() * 0.1f, 0.25f, 0.25f, 0.25f);
                        world.m_7106_((ParticleOptions)data, player.m_20185_(), player.m_20186_(), player.m_20189_(), (double)(0.2f * (float)(Math.random() - 0.5)), (double)(-0.01f * (float)Math.random()), (double)(0.2f * (float)(Math.random() - 0.5)));
                    }
                }
                this.setFlyCounter(stack, this.getFlyCounter(stack) + 3);
                if (this.getFlyCounter(stack) == 60) {
                    this.setFlying(stack, false);
                }
            }
            if (damaged) {
                player.f_19789_ = 0.0f;
            }
        }
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getFlyCounter(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        float frac = 1.0f - (float)this.getFlyCounter(stack) / 60.0f;
        return Math.round(13.0f * frac);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        float frac = 1.0f - (float)this.getFlyCounter(stack) / 60.0f;
        return Mth.m_14169_((float)(frac / 3.0f), (float)1.0f, (float)1.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int fly = this.getFlyCounter(stack);
        if (fly == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, false)) {
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 350, true);
            this.setFlying(stack, true);
            player.m_146850_(GameEvent.f_223697_);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static boolean isFlying(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_FLYING, false);
    }

    private void setFlying(ItemStack stack, boolean flying) {
        ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
    }

    private int getFlyCounter(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_FLYCOUNTER);
    }

    private void setFlyCounter(ItemStack stack, int counter) {
        stack.m_41784_().m_128405_(TAG_FLYCOUNTER, counter);
    }

    public static void doAvatarElytraBoost(Player p, Level world) {
        Vec3 lookDir = p.m_20154_();
        double mult = 1.25 * Math.pow(Math.E, -0.5 * p.m_20184_().m_82553_());
        p.m_20334_(p.m_20184_().m_7096_() + lookDir.m_7096_() * mult, p.m_20184_().m_7098_() + lookDir.m_7098_() * mult, p.m_20184_().m_7094_() + lookDir.m_7094_() * mult);
        if (!world.f_46443_) {
            XplatAbstractions.INSTANCE.sendToPlayer(p, new AvatarSkiesRodPacket(true));
            XplatAbstractions.INSTANCE.sendToTracking((Entity)p, new BotaniaEffectPacket(EffectType.AVATAR_TORNADO_BOOST, p.m_20185_(), p.m_20186_(), p.m_20189_(), p.m_19879_()));
        }
    }

    public static void doAvatarJump(Player p, Level world) {
        p.m_20334_(p.m_20184_().m_7096_(), 2.8, p.m_20184_().m_7094_());
        if (!world.f_46443_) {
            XplatAbstractions.INSTANCE.sendToPlayer(p, new AvatarSkiesRodPacket(false));
            XplatAbstractions.INSTANCE.sendToTracking((Entity)p, new BotaniaEffectPacket(EffectType.AVATAR_TORNADO_JUMP, p.m_20185_(), p.m_20186_(), p.m_20189_(), p.m_19879_()));
        }
    }

    private static void doAvatarMiscEffects(Player p, ManaReceiver tile) {
        p.m_9236_().m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), BotaniaSounds.dash, SoundSource.PLAYERS, 1.0f, 1.0f);
        p.m_146850_(GameEvent.f_157815_);
        p.m_7292_(new MobEffectInstance(BotaniaMobEffects.featherfeet, 100, 0));
        tile.receiveMana(-350);
    }

    private static void decAvatarCooldowns(Map<UUID, Integer> cooldownTag) {
        for (UUID key : cooldownTag.keySet()) {
            int val = cooldownTag.get(key);
            if (val > 0) {
                cooldownTag.put(key, val - 1);
                continue;
            }
            cooldownTag.remove(key);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.reequipAnimation(oldStack, newStack);
    }

    public boolean allowNbtUpdateAnimation(Player player, InteractionHand hand, ItemStack oldStack, ItemStack newStack) {
        return this.reequipAnimation(oldStack, newStack);
    }

    private boolean reequipAnimation(ItemStack before, ItemStack after) {
        return !before.m_150930_((Item)this) || SkiesRodItem.isFlying(before) != SkiesRodItem.isFlying(after);
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockEntity te = (BlockEntity)tile;
            Level world = te.m_58904_();
            Map<UUID, Integer> cooldowns = tile.getBoostCooldowns();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.m_58899_(), te.m_58900_(), te, null);
            if (!world.f_46443_) {
                SkiesRodItem.decAvatarCooldowns(cooldowns);
            }
            if (!world.f_46443_ && receiver.getCurrentMana() >= 350 && tile.isEnabled()) {
                double range = 5.5;
                double rangeY = 3.5;
                List players = world.m_45976_(Player.class, new AABB(te.m_58899_().m_252807_().m_82520_(-range, -rangeY, -range), te.m_58899_().m_252807_().m_82520_(range, rangeY, range)));
                for (Player p : players) {
                    int cooldown = 0;
                    if (cooldowns.containsKey(p.m_20148_())) {
                        cooldown = cooldowns.get(p.m_20148_());
                    }
                    if (p.m_6144_() || cooldown > 0) continue;
                    if (p.m_20184_().m_82553_() > 0.2 && p.m_20184_().m_82553_() < 5.0 && p.m_21255_()) {
                        SkiesRodItem.doAvatarElytraBoost(p, world);
                        SkiesRodItem.doAvatarMiscEffects(p, receiver);
                        cooldowns.put(p.m_20148_(), 20);
                        te.m_6596_();
                        continue;
                    }
                    if (!(p.m_20184_().m_7098_() > 0.3) || !(p.m_20184_().m_7098_() < 2.0) || p.m_21255_()) continue;
                    SkiesRodItem.doAvatarJump(p, world);
                    SkiesRodItem.doAvatarMiscEffects(p, receiver);
                }
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }
}

