/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ManaProficiencyArmor;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaItemHandlerImpl
implements ManaItemHandler {
    @Override
    public List<ItemStack> getManaItems(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (ItemStack stackInSlot : Iterables.concat((Iterable)player.m_150109_().f_35974_, (Iterable)player.m_150109_().f_35976_)) {
            if (stackInSlot.m_41619_() || XplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        XplatAbstractions.INSTANCE.fireManaItemEvent(player, toReturn);
        return toReturn;
    }

    @Override
    public List<ItemStack> getManaAccesories(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        Container acc = BotaniaAPI.instance().getAccessoriesInventory(player);
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.m_6643_());
        for (int slot = 0; slot < acc.m_6643_(); ++slot) {
            ItemStack stackInSlot = acc.m_8020_(slot);
            if (stackInSlot.m_41619_() || XplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    @Override
    public int requestMana(ItemStack stack, Player player, int manaToGet, boolean remove) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            ManaItem requestor;
            ManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || manaItem.getMana() <= 0 || (requestor = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !requestor.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItem.getMana());
            if (remove) {
                manaItem.addMana(-mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        return manaReceived;
    }

    @Override
    public boolean requestManaExact(ItemStack stack, Player player, int manaToGet, boolean remove) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        Object2IntOpenHashMap manaToRemove = new Object2IntOpenHashMap();
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItemSlot.getMana());
            if (remove) {
                manaToRemove.put((Object)manaItemSlot, mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        if (manaReceived == manaToGet) {
            for (Object2IntMap.Entry e : manaToRemove.object2IntEntrySet()) {
                ((ManaItem)e.getKey()).addMana(-e.getIntValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public int dispatchMana(ItemStack stack, Player player, int manaToSend, boolean add) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canReceiveManaFromItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            int received = manaItemSlot.getMana() + manaToSend <= manaItemSlot.getMaxMana() ? manaToSend : manaToSend - (manaItemSlot.getMana() + manaToSend - manaItemSlot.getMaxMana());
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return received;
        }
        return 0;
    }

    @Override
    public boolean dispatchManaExact(ItemStack stack, Player player, int manaToSend, boolean add) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            ManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot)).getMana() + manaToSend > manaItemSlot.getMaxMana() || !manaItemSlot.canReceiveManaFromItem(stack) || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return true;
        }
        return false;
    }

    private int discountManaForTool(ItemStack stack, Player player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - this.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    @Override
    public int requestManaForTool(ItemStack stack, Player player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestMana(stack, player, cost, remove);
    }

    @Override
    public boolean requestManaExactForTool(ItemStack stack, Player player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestManaExact(stack, player, cost, remove);
    }

    @Override
    public int getInvocationCountForTool(ItemStack stack, Player player, int manaToGet) {
        if (stack.m_41619_()) {
            return 0;
        }
        int cost = this.discountManaForTool(stack, player, manaToGet);
        int invocations = 0;
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            ManaItem manaItem;
            if (stackInSlot == stack) continue;
            ManaItem manaItemSlot = XplatAbstractions.INSTANCE.findManaItem(stackInSlot);
            int availableMana = manaItemSlot.getMana();
            if (!manaItemSlot.canExportManaToItem(stack) || availableMana <= cost || (manaItem = XplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            invocations += availableMana / cost;
        }
        return invocations;
    }

    @Override
    public float getFullDiscountForTools(Player player, ItemStack tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            Item item;
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (armor.m_41619_() || !((item = armor.m_41720_()) instanceof ManaDiscountArmor)) continue;
            ManaDiscountArmor discountArmor = (ManaDiscountArmor)item;
            discount += discountArmor.getDiscount(armor, i, player, tool);
        }
        int unbreaking = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)tool);
        discount += (float)unbreaking * 0.05f;
        discount = XplatAbstractions.INSTANCE.fireManaDiscountEvent(player, discount, tool);
        return discount;
    }

    @Override
    public boolean hasProficiency(Player player, ItemStack manaItem) {
        boolean proficient = false;
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ManaProficiencyArmor armor;
            Item item;
            ItemStack stack;
            if (e.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = player.m_6844_(e)).m_41619_() || !((item = stack.m_41720_()) instanceof ManaProficiencyArmor) || !(armor = (ManaProficiencyArmor)item).shouldGiveProficiency(stack, e, player, manaItem)) continue;
            proficient = true;
            break;
        }
        return XplatAbstractions.INSTANCE.fireManaProficiencyEvent(player, manaItem, proficient);
    }
}

