/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ElvenTradeEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png");

    public ElvenTradeEmiRecipe(ElvenTradeRecipe recipe) {
        super(BotaniaEmiPlugin.ELVEN_TRADE, recipe);
        this.input = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
        this.output = recipe.getOutputs().stream().map(EmiStack::of).toList();
    }

    public int getDisplayHeight() {
        return 90;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 10, 5, 71, 75, 20, 19));
        widgets.add((Widget)new ElevenTradeWidget(12, 22));
        int sx = 35;
        for (EmiIngredient ing : this.input) {
            widgets.addSlot(ing, sx, 0).drawBack(false);
            sx += 18;
        }
        sx = 83;
        for (EmiStack stack : this.output) {
            widgets.addSlot((EmiIngredient)stack, sx, 40).drawBack(false).recipeContext((EmiRecipe)this);
            sx += 18;
        }
    }

    private static class ElevenTradeWidget
    extends Widget {
        private final int x;
        private final int y;

        public ElevenTradeWidget(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Bounds getBounds() {
            return new Bounds(this.x, this.y, 0, 0);
        }

        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            PoseStack matrices = gui.m_280168_();
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix("block/alfheim_portal_swirl"));
            MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer v = immediate.m_6299_(RenderType.m_110451_());
            int startX = this.x;
            int startY = this.y;
            int stopX = this.x + 48;
            int stopY = this.y + 48;
            Matrix4f mat = matrices.m_85850_().m_252922_();
            Matrix3f n = matrices.m_85850_().m_252943_();
            v.m_252986_(mat, (float)startX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
            v.m_252986_(mat, (float)startX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
            v.m_252986_(mat, (float)stopX, (float)stopY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
            v.m_252986_(mat, (float)stopX, (float)startY, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_85969_(0xF000F0).m_252939_(n, 1.0f, 0.0f, 0.0f).m_5752_();
            immediate.m_109911_();
        }
    }
}

