/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PetalApothecaryRecipeCategory
implements IRecipeCategory<PetalApothecaryRecipe> {
    public static final RecipeType<PetalApothecaryRecipe> TYPE = RecipeType.create((String)"botania", (String)"petals", PetalApothecaryRecipe.class);
    public static final int CENTER_X = 48;
    public static final int CENTER_Y = 45;
    private final IDrawableStatic background;
    private final Component localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final Ingredient WATER_BUCKET = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_});

    public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 97);
        this.localizedName = Component.m_237115_((String)"botania.nei.petalApothecary");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 17, 11, 114, 82);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BotaniaBlocks.defaultAltar));
    }

    @NotNull
    public RecipeType<PetalApothecaryRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull PetalApothecaryRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 0, 4);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PetalApothecaryRecipe recipe, @NotNull IFocusGroup focusGroup) {
        PetalApothecaryRecipeCategory.setRecipeLayout(builder, (List<Ingredient>)recipe.m_7527_(), BotaniaBlocks.defaultAltar, recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), this.WATER_BUCKET, recipe.getReagent());
    }

    public static void setRecipeLayout(@NotNull IRecipeLayoutBuilder builder, List<Ingredient> ingredients, Block catalyst, ItemStack output, Ingredient ... reagents) {
        Vec2 center = new Vec2(48.0f, 45.0f);
        if (reagents.length > 0) {
            Vec2 reagentPoint = new Vec2(48.0f, 55.0f);
            builder.addSlot(RecipeIngredientRole.CATALYST, (int)reagentPoint.f_82470_, (int)reagentPoint.f_82471_).addItemStack(new ItemStack((ItemLike)catalyst));
            double angleBetweenReagents = 360.0 / (double)(reagents.length + 1);
            for (int i = 0; i < reagents.length; ++i) {
                reagentPoint = PetalApothecaryRecipeCategory.rotatePointAbout(reagentPoint, center, angleBetweenReagents);
                builder.addSlot(RecipeIngredientRole.INPUT, (int)reagentPoint.f_82470_, (int)reagentPoint.f_82471_).addIngredients(reagents[i]);
            }
        } else {
            builder.addSlot(RecipeIngredientRole.CATALYST, 48, 45).addItemStack(new ItemStack((ItemLike)catalyst));
        }
        double angleBetweenEach = 360.0 / (double)ingredients.size();
        Vec2 point = new Vec2(48.0f, 13.0f);
        for (Ingredient ingr : ingredients) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.f_82470_, (int)point.f_82471_).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(output);
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.f_82470_ - about.f_82470_) - Math.sin(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82470_;
        double newY = Math.sin(rad) * (double)(in.f_82470_ - about.f_82470_) + Math.cos(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82471_;
        return new Vec2((float)newX, (float)newY);
    }
}

