/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.events;

import java.util.stream.Stream;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import tschipp.carryon.common.config.ListHandler;

@EventBusSubscriber(modid="carryon")
public class ModBusEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void serverLoad(InterModProcessEvent event) {
        Stream messages = InterModComms.getMessages((String)"carryon");
        messages.forEach(msg -> {
            String method = msg.method();
            Object obj = msg.messageSupplier().get();
            if (!(obj instanceof String)) {
                return;
            }
            String str = (String)obj;
            switch (method) {
                case "blacklistBlock": {
                    ListHandler.addForbiddenTiles(str);
                    break;
                }
                case "blacklistEntity": {
                    ListHandler.addForbiddenEntities(str);
                    break;
                }
                case "whitelistBlock": {
                    ListHandler.addAllowedTiles(str);
                    break;
                }
                case "whitelistEntity": {
                    ListHandler.addAllowedEntities(str);
                    break;
                }
                case "blacklistStacking": {
                    ListHandler.addForbiddenStacking(str);
                    break;
                }
                case "whitelistStacking": {
                    ListHandler.addAllowedStacking(str);
                    break;
                }
            }
        });
    }
}

