/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.platform.Services;

public class CarriedObjectRender {
    public static boolean draw(Player player, PoseStack matrix, int light, float partialTicks, SubmitNodeCollector nodeCollector, boolean firstPerson) {
        if (Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod") || player == null) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        try {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                CarriedObjectRender.drawBlock(player, matrix, light, CarryRenderHelper.getRenderState(player), nodeCollector, firstPerson, partialTicks);
            } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                CarriedObjectRender.drawEntity(player, matrix, light, partialTicks, nodeCollector, firstPerson);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
            if (!render.renderLeftArm() && player.getMainArm() == HumanoidArm.LEFT) {
                return false;
            }
            if (!render.renderRightArm() && player.getMainArm() == HumanoidArm.RIGHT) {
                return false;
            }
        }
        return carry.isCarrying();
    }

    private static void drawBlock(Player player, PoseStack matrix, int light, BlockState state, SubmitNodeCollector nodeCollector, boolean firstPerson, float partialTicks) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        ItemStackRenderState renderState = new ItemStackRenderState();
        ItemStackRenderState.LayerRenderState layer = renderState.newLayer();
        layer.setRenderType(RenderType.glint());
        matrix.pushPose();
        PoseStack renderPose = CarryRenderHelper.setupBlockTransformations(player, matrix, carry, firstPerson);
        ItemStack renderStack = CarryRenderHelper.getRenderItemStack(player);
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, renderStack, ItemDisplayContext.NONE, player.level(), null, 0);
        renderState.submit(renderPose, nodeCollector, light, OverlayTexture.NO_OVERLAY, 0);
        matrix.popPose();
    }

    private static void drawEntity(Player player, PoseStack matrix, int light, float partialTicks, SubmitNodeCollector nodeCollector, boolean firstPerson) {
        EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
        Entity entity = CarryRenderHelper.getRenderEntity(player);
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (entity == null) {
            return;
        }
        Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialTicks);
        entity.setPos(playerpos.x, playerpos.y, playerpos.z);
        entity.xRotO = 0.0f;
        entity.yRotO = 0.0f;
        entity.setYHeadRot(0.0f);
        matrix.pushPose();
        CarryRenderHelper.setupEntityTransformations(player, matrix, carry, firstPerson);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).hurtTime = 0;
        }
        try {
            EntityRenderState renderState = manager.extractEntity(entity, 0.0f);
            renderState.shadowPieces.clear();
            renderState.lightCoords = light;
            manager.submit(renderState, new CameraRenderState(), 0.0, 0.0, 0.0, matrix, nodeCollector);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.popPose();
        if (!firstPerson) {
            matrix.popPose();
        }
    }
}

