/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.modeloverride;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.common.scripting.Matchables;

public class ModelOverride {
    private BlockStateParser.BlockResult parsedBlock;
    private Either<ItemStack, BlockState> renderObject;

    private ModelOverride(String raw, BlockStateParser.BlockResult parsedBlock, Type type, Either<ItemParser.ItemResult, BlockStateParser.BlockResult> parsedRHS) {
        this.parsedBlock = parsedBlock;
        parsedRHS.ifLeft(res -> {
            ItemStack stack = new ItemStack(res.item());
            if (res.components() != null) {
                stack.applyComponents(res.components());
            }
            this.renderObject = Either.left((Object)stack);
        });
        parsedRHS.ifRight(res -> {
            BlockState state = res.blockState();
            this.renderObject = Either.right((Object)state);
        });
    }

    public static DataResult<ModelOverride> of(String str, HolderLookup.Provider provider) {
        Either either;
        BlockStateParser.BlockResult res;
        if (!str.contains("->")) {
            return DataResult.error(() -> str + " must contain -> Arrow!");
        }
        String[] split = str.split("->");
        String from = split[0];
        String to = split[1];
        try {
            res = BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (String)from, (boolean)true);
        }
        catch (Exception e) {
            return DataResult.error(() -> "Error while parsing " + from + ":" + e.getMessage());
        }
        Type type = Type.ITEM;
        if (to.contains("(") && to.contains(")")) {
            String t = to.substring(to.indexOf("(") + 1, to.indexOf(")"));
            if (t.equals("block")) {
                type = Type.BLOCK;
            }
            to = to.substring(to.indexOf(")") + 1);
        }
        try {
            either = type == Type.ITEM ? Either.left((Object)new ItemParser(provider).parse(new StringReader(to))) : Either.right((Object)BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK, (String)to, (boolean)true));
        }
        catch (CommandSyntaxException e) {
            String finalTo = to;
            return DataResult.error(() -> "Error while parsing " + finalTo + ":" + e.getMessage());
        }
        return DataResult.success((Object)new ModelOverride(str, res, type, (Either<ItemParser.ItemResult, BlockStateParser.BlockResult>)either));
    }

    public boolean matches(BlockState state, @Nullable CompoundTag tag) {
        if (state.getBlock() == this.parsedBlock.blockState().getBlock() && this.matchesProperties(state, this.parsedBlock.properties())) {
            if (tag == null || this.parsedBlock.nbt() == null) {
                return true;
            }
            Matchables.NBTCondition nbt = new Matchables.NBTCondition(this.parsedBlock.nbt());
            return nbt.matches(tag);
        }
        return false;
    }

    public Either<ItemStack, BlockState> getRenderObject() {
        return this.renderObject;
    }

    private boolean matchesProperties(BlockState state, Map<Property<?>, Comparable<?>> props) {
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            Comparable val = state.getValue(entry.getKey());
            if (val == entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        ITEM,
        BLOCK;

    }
}

