/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import java.util.Optional;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    private PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    private void onReadAdditionalSaveData(ValueInput input, CallbackInfo ci) {
        Optional res = input.read("CarryOnData", CarryOnData.CODEC);
        res.ifPresent(data -> CarryOnDataManager.setCarryData((Player)this, data));
    }

    public void stopRiding() {
        CarryOnData carry;
        Entity entity = this.getVehicle();
        if (entity instanceof Player && entity.getPassengers().size() < 2 && (carry = CarryOnDataManager.getCarryData((Player)entity)).getType() == CarryOnData.CarryType.PLAYER) {
            carry.clear();
            ((Player)entity).removeEffect(MobEffects.SLOWNESS);
        }
        super.stopRiding();
    }
}

