/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.carry;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tschipp.carryon.carry.CarryOnDataCapability;
import tschipp.carryon.carry.ICarryOnDataCapability;
import tschipp.carryon.common.carry.CarryOnData;

public class CarryOnDataCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<ICarryOnDataCapability> CARRY_ON_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ICarryOnDataCapability>(){});
    private final CarryOnDataCapability impl = new CarryOnDataCapability();
    private final LazyOptional<ICarryOnDataCapability> opt = LazyOptional.of(() -> this.impl);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CARRY_ON_DATA_CAPABILITY ? this.opt.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registryAccess) {
        return (CompoundTag)CarryOnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.impl.getCarryData()).getOrThrow();
    }

    public void deserializeNBT(HolderLookup.Provider registryAccess, CompoundTag nbt) {
        CarryOnData data = (CarryOnData)CarryOnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow();
        this.impl.setCarryData(data);
    }
}

