/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.modeloverride;

import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;

public class ModelOverrideHandler {
    private static List<ModelOverride> OVERRIDES = new ArrayList<ModelOverride>();

    public static void initModelOverrides(class_7225.class_7874 provider) {
        OVERRIDES.clear();
        for (String ov : Constants.CLIENT_CONFIG.modelOverrides) {
            ModelOverrideHandler.addFromString(ov, provider);
        }
    }

    public static Optional<ModelOverride> getModelOverride(class_2680 state, @Nullable class_2487 tag) {
        for (ModelOverride ov : OVERRIDES) {
            if (!ov.matches(state, tag)) continue;
            return Optional.of(ov);
        }
        return Optional.empty();
    }

    public static void addFromString(String str, class_7225.class_7874 provider) {
        DataResult<ModelOverride> res = ModelOverride.of(str, provider);
        if (res.result().isPresent()) {
            ModelOverride override = (ModelOverride)res.result().get();
            OVERRIDES.add(override);
        } else {
            Constants.LOG.debug("Error while parsing ModelOverride: " + ((DataResult.Error)res.error().get()).message());
        }
    }
}

