/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.networking.clientbound;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.PacketBase;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ClientboundSyncScriptsPacket(class_2520 serialized) implements PacketBase
{
	public static final class_9139<class_9129, ClientboundSyncScriptsPacket> CODEC = class_9139.method_56434(
			class_9135.field_48555, ClientboundSyncScriptsPacket::serialized,
			ClientboundSyncScriptsPacket::new
	);

	public static final class_8710.class_9154<ClientboundSyncScriptsPacket> TYPE = new class_9154<>(Constants.PACKET_ID_SYNC_SCRIPTS);

	@Override
	public void handle(class_1657 player)
	{
		DataResult<List<CarryOnScript>> res = Codec.list(CarryOnScript.CODEC).parse(class_2509.field_11560, serialized);
		List<CarryOnScript> scripts = res.getOrThrow((s) -> {throw new RuntimeException("Failed deserializing carry on scripts on the client: " + s);});
		ScriptManager.SCRIPTS.clear();
		ScriptManager.SCRIPTS.addAll(scripts);
	}

	@Override
	public class_9154<ClientboundSyncScriptsPacket> method_56479() {
		return TYPE;
	}
}
